/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.service.impl;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.impl.AbstractService;
import com.alibaba.dubbo.governance.sync.util.Pair;
import com.alibaba.dubbo.governance.sync.util.SyncUtils;
import com.alibaba.dubbo.registry.common.domain.Override;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OverrideServiceImpl
extends AbstractService
implements OverrideService {
    public void saveOverride(Override override) {
        URL url = this.getUrlFromOverride(override);
        this.registryService.register(url);
    }

    public void updateOverride(Override override) {
        Long id = override.getId();
        if (id == null) {
            throw new IllegalStateException("no override id");
        }
        URL oldOverride = this.findOverrideUrl(id);
        if (oldOverride == null) {
            throw new IllegalStateException("Route was changed!");
        }
        URL newOverride = this.getUrlFromOverride(override);
        this.registryService.unregister(oldOverride);
        this.registryService.register(newOverride);
    }

    public void deleteOverride(Long id) {
        URL oldOverride = this.findOverrideUrl(id);
        if (oldOverride == null) {
            throw new IllegalStateException("Route was changed!");
        }
        this.registryService.unregister(oldOverride);
    }

    public void enableOverride(Long id) {
        if (id == null) {
            throw new IllegalStateException("no override id");
        }
        URL oldOverride = this.findOverrideUrl(id);
        if (oldOverride == null) {
            throw new IllegalStateException("Override was changed!");
        }
        if (oldOverride.getParameter("enabled", true)) {
            return;
        }
        URL newOverride = oldOverride.removeParameter("enabled");
        this.registryService.unregister(oldOverride);
        this.registryService.register(newOverride);
    }

    public void disableOverride(Long id) {
        if (id == null) {
            throw new IllegalStateException("no override id");
        }
        URL oldProvider = this.findOverrideUrl(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Override was changed!");
        }
        if (!oldProvider.getParameter("enabled", true)) {
            return;
        }
        URL newProvider = oldProvider.addParameter("enabled", false);
        this.registryService.unregister(oldProvider);
        this.registryService.register(newProvider);
    }

    private Map<Long, URL> findOverrideUrl(String service, String address, String application) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "configurators");
        if (service != null && service.length() > 0) {
            filter.put(".service", service);
        }
        if (address != null && address.length() > 0) {
            filter.put(".address", address);
        }
        if (application != null && application.length() > 0) {
            filter.put("application", application);
        }
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Override> findByAddress(String address) {
        return SyncUtils.url2OverrideList((Map)this.findOverrideUrl(null, address, null));
    }

    public List<Override> findByServiceAndAddress(String service, String address) {
        return SyncUtils.url2OverrideList((Map)this.findOverrideUrl(service, address, null));
    }

    public List<Override> findByApplication(String application) {
        return SyncUtils.url2OverrideList((Map)this.findOverrideUrl(null, null, application));
    }

    public List<Override> findByService(String service) {
        return SyncUtils.url2OverrideList((Map)this.findOverrideUrl(service, null, null));
    }

    public List<Override> findByServiceAndApplication(String service, String application) {
        return SyncUtils.url2OverrideList((Map)this.findOverrideUrl(service, null, application));
    }

    public List<Override> findAll() {
        return SyncUtils.url2OverrideList((Map)this.findOverrideUrl(null, null, null));
    }

    private Pair<Long, URL> findOverrideUrlPair(Long id) {
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), (String)"configurators", (Long)id);
    }

    public Override findById(Long id) {
        return SyncUtils.url2Override((Pair)this.findOverrideUrlPair(id));
    }

    private URL getUrlFromOverride(Override override) {
        return override.toUrl();
    }

    URL findOverrideUrl(Long id) {
        return this.getUrlFromOverride(this.findById(id));
    }
}

