/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.service.impl;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.governance.service.RouteService;
import com.alibaba.dubbo.governance.service.impl.AbstractService;
import com.alibaba.dubbo.governance.sync.util.Pair;
import com.alibaba.dubbo.governance.sync.util.SyncUtils;
import com.alibaba.dubbo.registry.common.domain.Route;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteServiceImpl
extends AbstractService
implements RouteService {
    public void createRoute(Route route) {
        this.registryService.register(route.toUrl());
    }

    public void updateRoute(Route route) {
        Long id = route.getId();
        if (id == null) {
            throw new IllegalStateException("no route id");
        }
        URL oldRoute = this.findRouteUrl(id);
        if (oldRoute == null) {
            throw new IllegalStateException("Route was changed!");
        }
        this.registryService.unregister(oldRoute);
        this.registryService.register(route.toUrl());
    }

    public void deleteRoute(Long id) {
        URL oldRoute = this.findRouteUrl(id);
        if (oldRoute == null) {
            throw new IllegalStateException("Route was changed!");
        }
        this.registryService.unregister(oldRoute);
    }

    public void enableRoute(Long id) {
        if (id == null) {
            throw new IllegalStateException("no route id");
        }
        URL oldRoute = this.findRouteUrl(id);
        if (oldRoute == null) {
            throw new IllegalStateException("Route was changed!");
        }
        if (oldRoute.getParameter("enabled", true)) {
            return;
        }
        this.registryService.unregister(oldRoute);
        URL newRoute = oldRoute.addParameter("enabled", true);
        this.registryService.register(newRoute);
    }

    public void disableRoute(Long id) {
        if (id == null) {
            throw new IllegalStateException("no route id");
        }
        URL oldRoute = this.findRouteUrl(id);
        if (oldRoute == null) {
            throw new IllegalStateException("Route was changed!");
        }
        if (!oldRoute.getParameter("enabled", true)) {
            return;
        }
        URL newRoute = oldRoute.addParameter("enabled", false);
        this.registryService.unregister(oldRoute);
        this.registryService.register(newRoute);
    }

    public List<Route> findAll() {
        return SyncUtils.url2RouteList((Map)this.findAllUrl());
    }

    private Map<Long, URL> findAllUrl() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "routers");
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public Route findRoute(Long id) {
        return SyncUtils.url2Route((Pair)this.findRouteUrlPair(id));
    }

    public Pair<Long, URL> findRouteUrlPair(Long id) {
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), (String)"routers", (Long)id);
    }

    private URL findRouteUrl(Long id) {
        return this.findRoute(id).toUrl();
    }

    private Map<Long, URL> findRouteUrl(String service, String address, boolean force) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "routers");
        if (service != null && service.length() > 0) {
            filter.put(".service", service);
        }
        if (address != null && address.length() > 0) {
            filter.put(".address", address);
        }
        if (force) {
            filter.put("force", "true");
        }
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Route> findByService(String serviceName) {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(serviceName, null, false));
    }

    public List<Route> findByAddress(String address) {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(null, address, false));
    }

    public List<Route> findByServiceAndAddress(String service, String address) {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(service, address, false));
    }

    public List<Route> findForceRouteByService(String service) {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(service, null, true));
    }

    public List<Route> findForceRouteByAddress(String address) {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(null, address, true));
    }

    public List<Route> findForceRouteByServiceAndAddress(String service, String address) {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(service, address, true));
    }

    public List<Route> findAllForceRoute() {
        return SyncUtils.url2RouteList((Map)this.findRouteUrl(null, null, true));
    }
}

