/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;

public class Addresses
extends Restful {
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ConsumerService consumerService;

    public void index(Map<String, Object> context) {
        String keyword;
        String application = (String)context.get("application");
        String service = (String)context.get("service");
        List providerAddresses = null;
        List consumerAddresses = null;
        if (application != null && application.length() > 0) {
            providerAddresses = this.providerService.findAddressesByApplication(application);
            consumerAddresses = this.consumerService.findAddressesByApplication(application);
        } else if (service != null && service.length() > 0) {
            providerAddresses = this.providerService.findAddressesByService(service);
            consumerAddresses = this.consumerService.findAddressesByService(service);
        } else {
            providerAddresses = this.providerService.findAddresses();
            consumerAddresses = this.consumerService.findAddresses();
        }
        TreeSet addresses = new TreeSet();
        if (providerAddresses != null) {
            addresses.addAll(providerAddresses);
        }
        if (consumerAddresses != null) {
            addresses.addAll(consumerAddresses);
        }
        context.put("providerAddresses", providerAddresses);
        context.put("consumerAddresses", consumerAddresses);
        context.put("addresses", addresses);
        if (context.get("service") == null && context.get("application") == null && context.get("address") == null) {
            context.put("address", "*");
        }
        if (StringUtils.isNotEmpty((String)(keyword = (String)context.get("keyword")))) {
            if ("*".equals(keyword)) {
                return;
            }
            keyword = keyword.toLowerCase();
            HashSet<String> newList = new HashSet<String>();
            HashSet<String> newProviders = new HashSet<String>();
            HashSet<String> newConsumers = new HashSet<String>();
            for (String o : addresses) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newList.add(o);
            }
            for (String o : providerAddresses) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newProviders.add(o);
            }
            for (String o : consumerAddresses) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newConsumers.add(o);
            }
            context.put("addresses", newList);
            context.put("providerAddresses", newProviders);
            context.put("consumerAddresses", newConsumers);
        }
    }

    public void search(Map<String, Object> context) {
        this.index(context);
        HashSet<String> newList = new HashSet<String>();
        Set list = (Set)context.get("addresses");
        String keyword = (String)context.get("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = keyword.toLowerCase();
            for (String o : list) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newList.add(o);
            }
        }
        context.put("addresses", newList);
    }
}

