/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.service.RouteService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Consumer;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Route;
import com.alibaba.dubbo.registry.common.route.OverrideUtils;
import com.alibaba.dubbo.registry.common.route.RouteRule;
import com.alibaba.dubbo.registry.common.route.RouteUtils;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class Consumers
extends Restful {
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private OverrideService overrideService;
    @Autowired
    private RouteService routeService;

    public void index(Map<String, Object> context) throws Exception {
        List overrides;
        List consumers;
        String service = (String)context.get("service");
        String application = (String)context.get("application");
        String address = (String)context.get("address");
        List providers = null;
        List routes = null;
        if (service != null && service.length() > 0) {
            consumers = this.consumerService.findByService(service);
            overrides = this.overrideService.findByService(service);
            providers = this.providerService.findByService(service);
            routes = this.routeService.findByService(service);
        } else if (address != null && address.length() > 0) {
            consumers = this.consumerService.findByAddress(address);
            overrides = this.overrideService.findByAddress(Tool.getIP((String)address));
        } else if (application != null && application.length() > 0) {
            consumers = this.consumerService.findByApplication(application);
            overrides = this.overrideService.findByApplication(application);
        } else {
            consumers = this.consumerService.findAll();
            overrides = this.overrideService.findAll();
        }
        if (consumers != null && consumers.size() > 0) {
            for (Consumer consumer : consumers) {
                if (service == null || service.length() == 0) {
                    providers = this.providerService.findByService(consumer.getService());
                    routes = this.routeService.findByService(consumer.getService());
                }
                ArrayList routed = new ArrayList();
                consumer.setProviders(RouteUtils.route((String)consumer.getService(), (String)consumer.getAddress(), (String)consumer.getParameters(), (List)providers, (List)overrides, (List)routes, null, routed));
                consumer.setRoutes(routed);
                OverrideUtils.setConsumerOverrides((Consumer)consumer, (List)overrides);
            }
        }
        context.put("consumers", consumers);
    }

    public void show(Long id, Map<String, Object> context) {
        Consumer consumer = this.consumerService.findConsumer(id);
        List providers = this.providerService.findByService(consumer.getService());
        List routes = this.routeService.findByService(consumer.getService());
        List overrides = this.overrideService.findByService(consumer.getService());
        ArrayList routed = new ArrayList();
        consumer.setProviders(RouteUtils.route((String)consumer.getService(), (String)consumer.getAddress(), (String)consumer.getParameters(), (List)providers, (List)overrides, (List)routes, null, routed));
        consumer.setRoutes(routed);
        OverrideUtils.setConsumerOverrides((Consumer)consumer, (List)overrides);
        context.put("consumer", consumer);
        context.put("providers", consumer.getProviders());
        context.put("routes", consumer.getRoutes());
        context.put("overrides", consumer.getOverrides());
    }

    public void edit(Long id, Map<String, Object> context) {
        this.show(id, context);
    }

    public boolean update(Consumer newConsumer, Map<String, Object> context) {
        Long id = newConsumer.getId();
        String parameters = newConsumer.getParameters();
        Consumer consumer = this.consumerService.findConsumer(id);
        if (consumer == null) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
            return false;
        }
        String service = consumer.getService();
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        Map oldMap = StringUtils.parseQueryString((String)consumer.getParameters());
        Map newMap = StringUtils.parseQueryString((String)parameters);
        for (Map.Entry entry : oldMap.entrySet()) {
            if (!((String)entry.getValue()).equals(newMap.get(entry.getKey()))) continue;
            newMap.remove(entry.getKey());
        }
        String address = consumer.getAddress();
        List overrides = this.overrideService.findByServiceAndAddress(consumer.getService(), consumer.getAddress());
        OverrideUtils.setConsumerOverrides((Consumer)consumer, (List)overrides);
        Override override = consumer.getOverride();
        if (override != null) {
            if (newMap.size() > 0) {
                override.setParams(StringUtils.toQueryString((Map)newMap));
                override.setEnabled(true);
                override.setOperator(this.operator);
                override.setOperatorAddress(this.operatorAddress);
                this.overrideService.updateOverride(override);
            } else {
                this.overrideService.deleteOverride(override.getId());
            }
        } else {
            override = new Override();
            override.setService(service);
            override.setAddress(address);
            override.setParams(StringUtils.toQueryString((Map)newMap));
            override.setEnabled(true);
            override.setOperator(this.operator);
            override.setOperatorAddress(this.operatorAddress);
            this.overrideService.saveOverride(override);
        }
        return true;
    }

    public void routed(Long id, Map<String, Object> context) {
        this.show(id, context);
    }

    public void notified(Long id, Map<String, Object> context) {
        this.show(id, context);
    }

    public void overrided(Long id, Map<String, Object> context) {
        this.show(id, context);
    }

    public boolean shield(Long[] ids, Map<String, Object> context) throws Exception {
        return this.mock(ids, context, "force:return null");
    }

    public boolean tolerant(Long[] ids, Map<String, Object> context) throws Exception {
        return this.mock(ids, context, "fail:return null");
    }

    public boolean recover(Long[] ids, Map<String, Object> context) throws Exception {
        return this.mock(ids, context, "");
    }

    private boolean mock(Long[] ids, Map<String, Object> context, String mock) throws Exception {
        if (ids == null || ids.length == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (Long id : ids) {
            Consumer c = this.consumerService.findConsumer(id);
            if (c == null) continue;
            consumers.add(c);
            if (this.currentUser.hasServicePrivilege(c.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{c.getService()}));
            return false;
        }
        for (Consumer consumer : consumers) {
            String address;
            String service = consumer.getService();
            List overrides = this.overrideService.findByServiceAndAddress(service, address = Tool.getIP((String)consumer.getAddress()));
            if (overrides != null && overrides.size() > 0) {
                for (Override override : overrides) {
                    Map map = StringUtils.parseQueryString((String)override.getParams());
                    if (mock == null || mock.length() == 0) {
                        map.remove("mock");
                    } else {
                        map.put("mock", URL.encode((String)mock));
                    }
                    if (map.size() > 0) {
                        override.setParams(StringUtils.toQueryString((Map)map));
                        override.setEnabled(true);
                        override.setOperator(this.operator);
                        override.setOperatorAddress(this.operatorAddress);
                        this.overrideService.updateOverride(override);
                        continue;
                    }
                    this.overrideService.deleteOverride(override.getId());
                }
                continue;
            }
            if (mock == null || mock.length() <= 0) continue;
            Override override = new Override();
            override.setService(service);
            override.setAddress(address);
            override.setParams("mock=" + URL.encode((String)mock));
            override.setEnabled(true);
            override.setOperator(this.operator);
            override.setOperatorAddress(this.operatorAddress);
            this.overrideService.saveOverride(override);
        }
        return true;
    }

    public boolean allshield(Map<String, Object> context) throws Exception {
        return this.allmock(context, "force:return null");
    }

    public boolean alltolerant(Map<String, Object> context) throws Exception {
        return this.allmock(context, "fail:return null");
    }

    public boolean allrecover(Map<String, Object> context) throws Exception {
        return this.allmock(context, "");
    }

    private boolean allmock(Map<String, Object> context, String mock) throws Exception {
        String service = (String)context.get("service");
        if (service == null || service.length() == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        List overrides = this.overrideService.findByService(service);
        Override allOverride = null;
        if (overrides != null && overrides.size() > 0) {
            for (Override override : overrides) {
                if (!override.isDefault()) continue;
                allOverride = override;
                break;
            }
        }
        if (allOverride != null) {
            Map map = StringUtils.parseQueryString((String)allOverride.getParams());
            if (mock == null || mock.length() == 0) {
                map.remove("mock");
            } else {
                map.put("mock", URL.encode((String)mock));
            }
            if (map.size() > 0) {
                allOverride.setParams(StringUtils.toQueryString((Map)map));
                allOverride.setEnabled(true);
                allOverride.setOperator(this.operator);
                allOverride.setOperatorAddress(this.operatorAddress);
                this.overrideService.updateOverride(allOverride);
            } else {
                this.overrideService.deleteOverride(allOverride.getId());
            }
        } else if (mock != null && mock.length() > 0) {
            Override override = new Override();
            override.setService(service);
            override.setParams("mock=" + URL.encode((String)mock));
            override.setEnabled(true);
            override.setOperator(this.operator);
            override.setOperatorAddress(this.operatorAddress);
            this.overrideService.saveOverride(override);
        }
        return true;
    }

    public boolean allow(Long[] ids, Map<String, Object> context) throws Exception {
        return this.access(ids, context, true, false);
    }

    public boolean forbid(Long[] ids, Map<String, Object> context) throws Exception {
        return this.access(ids, context, false, false);
    }

    public boolean onlyallow(Long[] ids, Map<String, Object> context) throws Exception {
        return this.access(ids, context, true, true);
    }

    public boolean onlyforbid(Long[] ids, Map<String, Object> context) throws Exception {
        return this.access(ids, context, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private boolean access(Long[] ids, Map<String, Object> context, boolean allow, boolean only) throws Exception {
        String service;
        void var8_10;
        if (ids == null || ids.length == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        Long[] arr$ = ids;
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_10 < len$) {
            Long id = arr$[var8_10];
            Consumer c = this.consumerService.findConsumer(id);
            if (c != null) {
                consumers.add(c);
                if (!this.currentUser.hasServicePrivilege(c.getService())) {
                    context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{c.getService()}));
                    return false;
                }
            }
            ++var8_10;
        }
        HashMap<String, HashSet<String>> serviceAddresses = new HashMap<String, HashSet<String>>();
        for (Consumer consumer : consumers) {
            service = consumer.getService();
            String address = Tool.getIP((String)consumer.getAddress());
            HashSet<String> addresses = (HashSet<String>)serviceAddresses.get(service);
            if (addresses == null) {
                addresses = new HashSet<String>();
                serviceAddresses.put(service, addresses);
            }
            addresses.add(address);
        }
        for (Map.Entry entry : serviceAddresses.entrySet()) {
            service = (String)entry.getKey();
            boolean isFirst = false;
            List routes = this.routeService.findForceRouteByService(service);
            Route route = null;
            if (routes == null || routes.size() == 0) {
                isFirst = true;
                route = new Route();
                route.setService(service);
                route.setForce(true);
                route.setName(service + " blackwhitelist");
                route.setFilterRule("false");
                route.setEnabled(true);
            } else {
                route = (Route)routes.get(0);
            }
            Map<String, RouteRule.MatchPair> when = null;
            RouteRule.MatchPair matchPair = null;
            if (isFirst) {
                when = new HashMap();
                matchPair = new RouteRule.MatchPair(new HashSet(), new HashSet());
                when.put("consumer.host", matchPair);
            } else {
                when = RouteRule.parseRule((String)route.getMatchRule());
                matchPair = (RouteRule.MatchPair)when.get("consumer.host");
            }
            if (only) {
                matchPair.getUnmatches().clear();
                matchPair.getMatches().clear();
                if (allow) {
                    matchPair.getUnmatches().addAll((Collection)entry.getValue());
                } else {
                    matchPair.getMatches().addAll((Collection)entry.getValue());
                }
            } else {
                for (String consumerAddress : (Set)entry.getValue()) {
                    if (matchPair.getUnmatches().size() > 0) {
                        matchPair.getMatches().remove(consumerAddress);
                        if (allow) {
                            matchPair.getUnmatches().add(consumerAddress);
                            continue;
                        }
                        matchPair.getUnmatches().remove(consumerAddress);
                        continue;
                    }
                    if (allow) {
                        matchPair.getMatches().remove(consumerAddress);
                        continue;
                    }
                    matchPair.getMatches().add(consumerAddress);
                }
            }
            StringBuilder sb = new StringBuilder();
            RouteRule.contidionToString((StringBuilder)sb, when);
            route.setMatchRule(sb.toString());
            route.setUsername(this.operator);
            if (matchPair.getMatches().size() > 0 || matchPair.getUnmatches().size() > 0) {
                if (isFirst) {
                    this.routeService.createRoute(route);
                    continue;
                }
                this.routeService.updateRoute(route);
                continue;
            }
            if (isFirst) continue;
            this.routeService.deleteRoute(route.getId());
        }
        return true;
    }
}

