/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.domain;

import com.alibaba.dubbo.registry.common.domain.Entity;
import com.alibaba.dubbo.registry.common.route.ParseUtils;
import java.util.Arrays;
import java.util.List;

public class User
extends Entity {
    private static final long serialVersionUID = 7330539198581235339L;
    public static final String REALM = "dubbo";
    public static final String ROOT = "R";
    public static final String ADMINISTRATOR = "A";
    public static final String MANAGER = "M";
    public static final String GUEST = "G";
    public static final String ANONYMOUS = "anonymous";
    public static final String LEGACY = "legacy";
    private String username;
    private String password;
    private String role;
    private String creator;
    private boolean enabled;
    private String name;
    private String department;
    private String email;
    private String phone;
    private String alitalk;
    private String locale;
    private String servicePrivilege;
    private List<String> servicePrivileges;

    public User() {
    }

    public User(Long id) {
        super(id);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean hasServicePrivilege(String[] services) {
        if (services == null || services.length == 0) {
            throw new IllegalArgumentException("services == null");
        }
        for (String service : services) {
            boolean r = this.hasServicePrivilege(service);
            if (r) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrivilege(String servicePrivilege) {
        String[] privileges;
        if (servicePrivilege == null || servicePrivilege.length() == 0) {
            return true;
        }
        for (String privilege : privileges = servicePrivilege.trim().split("\\s*,\\s*")) {
            if (privilege.endsWith("*")) {
                privilege = privilege.substring(0, privilege.length() - 1);
            }
            if (privilege.indexOf(42) <= -1) continue;
            return false;
        }
        return true;
    }

    public boolean canGrantPrivilege(String servicePrivilege) {
        String[] privileges;
        if (servicePrivilege == null || servicePrivilege.length() == 0) {
            return true;
        }
        if (this.servicePrivileges == null || this.servicePrivileges.size() == 0) {
            return false;
        }
        for (String privilege : privileges = servicePrivilege.trim().split("\\s*,\\s*")) {
            boolean hasPrivilege = false;
            for (String ownPrivilege : this.servicePrivileges) {
                if (!this.matchPrivilege(ownPrivilege, privilege)) continue;
                hasPrivilege = true;
            }
            if (hasPrivilege) continue;
            return false;
        }
        return true;
    }

    private boolean matchPrivilege(String ownPrivilege, String privilege) {
        if ("*".equals(ownPrivilege) || ownPrivilege.equals(privilege)) {
            return true;
        }
        if (privilege.endsWith("*")) {
            if (!ownPrivilege.endsWith("*")) {
                return false;
            }
            privilege = privilege.substring(0, privilege.length() - 1);
            ownPrivilege = ownPrivilege.substring(0, ownPrivilege.length() - 1);
            return privilege.startsWith(ownPrivilege);
        }
        if (ownPrivilege.endsWith("*")) {
            ownPrivilege = ownPrivilege.substring(0, ownPrivilege.length() - 1);
        }
        return privilege.startsWith(ownPrivilege);
    }

    public boolean hasServicePrivilege(String service) {
        if (service == null || service.length() == 0) {
            return false;
        }
        if (this.role == null || GUEST.equalsIgnoreCase(this.role)) {
            return false;
        }
        if (ROOT.equalsIgnoreCase(this.role)) {
            return true;
        }
        if (this.servicePrivileges != null && this.servicePrivileges.size() > 0) {
            for (String privilege : this.servicePrivileges) {
                boolean ok = ParseUtils.isMatchGlobPattern((String)privilege, (String)service);
                if (!ok) continue;
                return true;
            }
        }
        return false;
    }

    public String getServicePrivilege() {
        return this.servicePrivilege;
    }

    public void setServicePrivilege(String servicePrivilege) {
        this.servicePrivilege = servicePrivilege;
        if (servicePrivilege != null && servicePrivilege.length() > 0) {
            this.servicePrivileges = Arrays.asList(servicePrivilege.trim().split("\\s*,\\s*"));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAlitalk() {
        return this.alitalk;
    }

    public void setAlitalk(String alitalk) {
        this.alitalk = alitalk;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

