/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.route;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.common.route.ParseUtils;
import com.alibaba.dubbo.registry.common.route.RouteRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RouteRuleUtils {
    private RouteRuleUtils() {
    }

    public static <T extends Collection<String>> Map<String, RouteRule.MatchPair> expandCondition(Map<String, RouteRule.MatchPair> condition, String srcKeyName, String destKeyName, Map<String, T> expandName2Set) {
        if (null == condition || StringUtils.isEmpty((String)srcKeyName) || StringUtils.isEmpty((String)destKeyName)) {
            return condition;
        }
        RouteRule.MatchPair matchPair = condition.get(srcKeyName);
        if (matchPair == null) {
            return condition;
        }
        HashMap<String, RouteRule.MatchPair> ret = new HashMap<String, RouteRule.MatchPair>();
        for (Map.Entry<String, RouteRule.MatchPair> entry : condition.entrySet()) {
            String condName = entry.getKey();
            if (!condName.equals(srcKeyName) && !condName.equals(destKeyName)) {
                RouteRule.MatchPair p = entry.getValue();
                if (p == null) continue;
                ret.put(condName, p);
                continue;
            }
            if (!condName.equals(srcKeyName)) continue;
            RouteRule.MatchPair from = condition.get(srcKeyName);
            RouteRule.MatchPair to = condition.get(destKeyName);
            if (from == null || from.getMatches().isEmpty() && from.getUnmatches().isEmpty()) {
                if (to == null) continue;
                ret.put(destKeyName, to);
                continue;
            }
            HashSet matches = new HashSet();
            HashSet unmatches = new HashSet();
            for (String s : from.getMatches()) {
                if (expandName2Set == null || !expandName2Set.containsKey(s)) continue;
                matches.addAll((Collection)expandName2Set.get(s));
            }
            for (String s : from.getUnmatches()) {
                if (expandName2Set == null || !expandName2Set.containsKey(s)) continue;
                unmatches.addAll((Collection)expandName2Set.get(s));
            }
            if (to != null) {
                matches.addAll(to.getMatches());
                unmatches.addAll(to.getUnmatches());
            }
            ret.put(destKeyName, new RouteRule.MatchPair(matches, unmatches));
        }
        return ret;
    }

    public static boolean isMatchCondition(Map<String, RouteRule.MatchPair> condition, Map<String, String> valueParams, Map<String, String> kv) {
        if (condition != null && condition.size() > 0) {
            for (Map.Entry<String, RouteRule.MatchPair> entry : condition.entrySet()) {
                String condName = entry.getKey();
                RouteRule.MatchPair p = entry.getValue();
                String value = kv.get(condName);
                Set matches = p.getMatches();
                if (matches != null && matches.size() > 0 && !ParseUtils.isMatchGlobPatternsNeedInterpolate((Collection)matches, valueParams, (String)value)) {
                    return false;
                }
                Set unmatches = p.getUnmatches();
                if (unmatches == null || unmatches.size() <= 0 || !ParseUtils.isMatchGlobPatternsNeedInterpolate((Collection)unmatches, valueParams, (String)value)) continue;
                return false;
            }
        }
        return true;
    }

    public static Set<String> filterServiceByRule(List<String> services, RouteRule rule) {
        if (null == services || services.isEmpty() || rule == null) {
            return new HashSet<String>();
        }
        RouteRule.MatchPair p = (RouteRule.MatchPair)rule.getWhenCondition().get("service");
        if (p == null) {
            return new HashSet<String>();
        }
        Set filter = ParseUtils.filterByGlobPattern((Collection)p.getMatches(), services);
        Set set = ParseUtils.filterByGlobPattern((Collection)p.getUnmatches(), services);
        filter.addAll(set);
        return filter;
    }
}

