/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.status;

import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;

public class MemoryStatusChecker
implements StatusChecker {
    public Status check() {
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        boolean ok = maxMemory - (totalMemory - freeMemory) > 2048L;
        String msg = "Max:" + maxMemory / 1024L / 1024L + "M, Total:" + totalMemory / 1024L / 1024L + "M, Free:" + freeMemory / 1024L / 1024L + "M, Use:" + (totalMemory / 1024L / 1024L - freeMemory / 1024L / 1024L) + "M";
        return new Status(ok ? Status.Level.OK : Status.Level.WARN, msg);
    }
}

