/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.util;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class MessageSource {
    private static final Logger logger = LoggerFactory.getLogger(MessageSource.class);
    private final ResourceBundle resourceBundle;
    private final String errorPrefix;

    public MessageSource(ResourceBundle resourceBundle) {
        this(resourceBundle, null);
    }

    public MessageSource(ResourceBundle resourceBundle, String errorPrefix) {
        this.resourceBundle = resourceBundle;
        this.errorPrefix = errorPrefix == null ? "" : errorPrefix + " ";
    }

    public String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (Throwable t) {
            logger.warn(this.errorPrefix + t.getMessage(), t);
            return key;
        }
    }

    public String getString(String key, Object ... args) {
        try {
            return new MessageFormat(this.resourceBundle.getString(key)).format(args);
        }
        catch (Throwable t) {
            logger.warn(this.errorPrefix + t.getMessage(), t);
            return key;
        }
    }
}

