/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization;

import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTConfiguration;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import de.ruedigermoeller.serialization.util.FSTIdentity2IdMap;
import de.ruedigermoeller.serialization.util.FSTInt2ObjectMap;
import de.ruedigermoeller.serialization.util.FSTObject2IntMap;
import de.ruedigermoeller.serialization.util.FSTUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FSTClazzNameRegistry {
    public static final int LOWEST_CLZ_ID = 3;
    FSTIdentity2IdMap clzToId;
    FSTInt2ObjectMap idToClz;
    FSTClazzNameRegistry parent;
    FSTConfiguration conf;
    int classIdCount = 3;
    HashMap<String, Class> classCache = new HashMap(200);
    AtomicBoolean classCacheLock = new AtomicBoolean(false);

    public FSTClazzNameRegistry(FSTClazzNameRegistry par, FSTConfiguration conf) {
        this.parent = par;
        this.conf = conf;
        if (this.parent != null) {
            this.classIdCount = this.parent.classIdCount + 1;
            this.clzToId = new FSTIdentity2IdMap(13);
            this.idToClz = new FSTInt2ObjectMap(13);
        } else {
            this.clzToId = new FSTIdentity2IdMap(FSTObject2IntMap.adjustSize(400));
            this.idToClz = new FSTInt2ObjectMap(FSTObject2IntMap.adjustSize(400));
        }
    }

    public void clear() {
        if (this.clzToId.size() > 0) {
            this.clzToId.clear();
            this.idToClz.clear();
        }
        this.classIdCount = 3;
        if (this.parent != null) {
            this.classIdCount = this.parent.classIdCount + 1;
        }
    }

    void registerClass(Class c) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.registerClassNoLookup(c, null);
    }

    private void registerClassNoLookup(Class c, FSTClazzInfo cli) {
        this.addClassMapping(c, this.classIdCount++, cli);
    }

    public void registerClass(Class c, int code) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(c, code, null);
    }

    protected void addClassMapping(Class c, int id, FSTClazzInfo clInfo) {
        this.clzToId.put(c, id);
        if (clInfo == null) {
            clInfo = this.conf.getCLInfoRegistry().getCLInfo(c);
        }
        this.idToClz.put(id, clInfo);
        if (this.parent == null) {
            clInfo.setClzId(id);
        }
    }

    public int getIdFromClazz(Class c) {
        int res = Integer.MIN_VALUE;
        if (this.parent != null) {
            res = this.parent.getIdFromClazz(c);
        }
        if (res == Integer.MIN_VALUE) {
            res = this.clzToId.get(c);
        }
        return res;
    }

    public void encodeClass(FSTObjectOutput out, FSTClazzInfo ci) throws IOException {
        int clzId = ci.getClzId();
        if (clzId >= 0) {
            out.writeCShort((short)clzId);
        } else if (ci.isAsciiNameShortString) {
            Class aClass = ci.getClazz();
            int clid = this.getIdFromClazz(aClass);
            if (clid != Integer.MIN_VALUE) {
                out.writeCShort((short)clid);
            } else {
                byte[] bufferedName = ci.getBufferedName();
                out.writeCShort((short)1);
                out.writeFByte((char)bufferedName.length);
                out.writeFByteArr(bufferedName, 0, bufferedName.length);
                this.registerClassNoLookup(aClass, ci);
            }
        } else {
            this.encodeClass(out, ci.getClazz());
        }
    }

    public void encodeClass(FSTObjectOutput out, Class c) throws IOException {
        int clid = this.getIdFromClazz(c);
        if (clid != Integer.MIN_VALUE) {
            out.writeCShort((short)clid);
        } else {
            this.encodeClassName(out, c);
        }
    }

    private void encodeClassName(FSTObjectOutput out, Class c) throws IOException {
        out.writeCShort((short)0);
        out.writeStringUTF(c.getName());
        this.registerClassNoLookup(c, null);
    }

    public FSTClazzInfo decodeClass(FSTObjectInput in) throws IOException, ClassNotFoundException {
        short c = in.readCShort();
        if (c < 3) {
            String clName = c == 0 ? in.readStringUTF() : in.readStringAsc();
            Class cl = this.classForName(clName);
            FSTClazzInfo clInfo = this.conf.getCLInfoRegistry().getCLInfo(cl);
            this.registerClassNoLookup(cl, clInfo);
            return clInfo;
        }
        FSTClazzInfo aClass = this.getClazzFromId(c);
        if (aClass == null) {
            throw new RuntimeException("unable to decode class from code " + c);
        }
        return aClass;
    }

    public Class classForName(String clName) throws ClassNotFoundException {
        if (this.parent != null) {
            return this.parent.classForName(clName);
        }
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        Class res = this.classCache.get(clName);
        if (res == null) {
            try {
                res = Class.forName(clName, false, this.conf.getClassLoader());
            }
            catch (Throwable th) {
                if (clName.endsWith("_Struct")) {
                    try {
                        clName = clName.substring(0, clName.length() - "_Struct".length());
                        Class<?> onHeapStructClz = this.classCache.get(clName);
                        if (onHeapStructClz == null) {
                            onHeapStructClz = Class.forName(clName);
                        }
                        res = FSTStructFactory.getInstance().getProxyClass(onHeapStructClz);
                    }
                    catch (Throwable th1) {
                        throw FSTUtil.rethrow(th1);
                    }
                }
                throw new RuntimeException("CLASSNAME:" + clName, th);
            }
            if (res != null) {
                this.classCache.put(clName, res);
            }
        }
        this.classCacheLock.set(false);
        return res;
    }

    public void registerClazzFromOtherLoader(Class cl) {
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        this.classCache.put(cl.getName(), cl);
        this.classCacheLock.set(false);
    }

    public FSTClazzInfo getClazzFromId(int c) {
        FSTClazzInfo res = null;
        if (this.parent != null) {
            res = this.parent.getClazzFromId(c);
        }
        if (res == null) {
            return (FSTClazzInfo)this.idToClz.get(c);
        }
        return res;
    }
}

