/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.helpers.IOUtils;

public class DelegatingInputStream
extends InputStream {
    private InputStream is;
    private AttachmentDeserializer deserializer;
    private boolean isClosed;

    DelegatingInputStream(InputStream is, AttachmentDeserializer ads) {
        this.is = is;
        this.deserializer = ads;
    }

    DelegatingInputStream(InputStream is) {
        this.is = is;
        this.deserializer = null;
    }

    public void close() throws IOException {
        IOUtils.consume(this.is);
        this.is.close();
        if (!this.isClosed && this.deserializer != null) {
            this.deserializer.markClosed(this);
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public synchronized void mark(int arg0) {
        this.is.mark(arg0);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public int read(byte[] bytes, int arg1, int arg2) throws IOException {
        return this.is.read(bytes, arg1, arg2);
    }

    public int read(byte[] bytes) throws IOException {
        return this.is.read(bytes);
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public void setInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    public InputStream getInputStream() {
        return this.is;
    }
}

