/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.spi.HttpResponse;

@ChannelHandler.Sharable
public class RestEasyHttpResponseEncoder
extends OneToOneEncoder {
    private final RequestDispatcher dispatcher;

    public RestEasyHttpResponseEncoder(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            NettyHttpResponse nettyResponse = (NettyHttpResponse)msg;
            HttpResponseStatus status = HttpResponseStatus.valueOf((int)nettyResponse.getStatus());
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            for (Map.Entry entry : nettyResponse.getOutputHeaders().entrySet()) {
                String key = (String)entry.getKey();
                for (Object value : (List)entry.getValue()) {
                    RuntimeDelegate.HeaderDelegate delegate = this.dispatcher.providerFactory.getHeaderDelegate(value.getClass());
                    if (delegate != null) {
                        response.addHeader(key, (Object)delegate.toString(value));
                        continue;
                    }
                    response.setHeader(key, (Object)value.toString());
                }
            }
            nettyResponse.getOutputStream().flush();
            response.setContent(nettyResponse.getBuffer());
            if (nettyResponse.isKeepAlive()) {
                response.setHeader("Content-Length", (Object)response.getContent().readableBytes());
                response.setHeader("Connection", (Object)"keep-alive");
            }
            return response;
        }
        return msg;
    }
}

