/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.core.impl;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.util.ByteBufferMatcher;
import com.google.code.yanf4j.util.ShiftAndByteBufferMatcher;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class TextLineCodecFactory
implements CodecFactory {
    public static final IoBuffer SPLIT = IoBuffer.wrap("\r\n".getBytes());
    private static final ByteBufferMatcher SPLIT_PATTERN = new ShiftAndByteBufferMatcher(SPLIT);
    public static final String DEFAULT_CHARSET_NAME = "utf-8";
    private Charset charset;
    private CodecFactory.Decoder decoder = new StringDecoder();
    private CodecFactory.Encoder encoder = new StringEncoder();

    public TextLineCodecFactory() {
        this.charset = Charset.forName(DEFAULT_CHARSET_NAME);
    }

    public TextLineCodecFactory(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public CodecFactory.Decoder getDecoder() {
        return this.decoder;
    }

    public CodecFactory.Encoder getEncoder() {
        return this.encoder;
    }

    class StringEncoder
    implements CodecFactory.Encoder {
        StringEncoder() {
        }

        public IoBuffer encode(Object msg, Session session) {
            if (msg == null) {
                return null;
            }
            String message = (String)msg;
            ByteBuffer buff = TextLineCodecFactory.this.charset.encode(message);
            IoBuffer resultBuffer = IoBuffer.allocate(buff.remaining() + SPLIT.remaining());
            resultBuffer.put(buff);
            resultBuffer.put(SPLIT.slice());
            resultBuffer.flip();
            return resultBuffer;
        }
    }

    class StringDecoder
    implements CodecFactory.Decoder {
        StringDecoder() {
        }

        public Object decode(IoBuffer buffer, Session session) {
            String result = null;
            int index = SPLIT_PATTERN.matchFirst(buffer);
            if (index >= 0) {
                int limit = buffer.limit();
                buffer.limit(index);
                CharBuffer charBuffer = TextLineCodecFactory.this.charset.decode(buffer.buf());
                result = charBuffer.toString();
                buffer.limit(limit);
                buffer.position(index + SPLIT.remaining());
            }
            return result;
        }
    }
}

