/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResponseStatus {
    NO_ERROR{

        public short fieldValue() {
            return 0;
        }

        public String errorMessage() {
            return "No error";
        }
    }
    ,
    KEY_NOT_FOUND{

        public short fieldValue() {
            return 1;
        }

        public String errorMessage() {
            return "Key is not found.";
        }
    }
    ,
    KEY_EXISTS{

        public short fieldValue() {
            return 2;
        }

        public String errorMessage() {
            return "Key is already existed.";
        }
    }
    ,
    VALUE_TOO_BIG{

        public short fieldValue() {
            return 3;
        }

        public String errorMessage() {
            return "Value is too big.";
        }
    }
    ,
    INVALID_ARGUMENTS{

        public short fieldValue() {
            return 4;
        }

        public String errorMessage() {
            return "Invalid arguments.";
        }
    }
    ,
    ITEM_NOT_STORED{

        public short fieldValue() {
            return 5;
        }

        public String errorMessage() {
            return "Item is not stored.";
        }
    }
    ,
    INC_DEC_NON_NUM{

        public short fieldValue() {
            return 6;
        }

        public String errorMessage() {
            return "Incr/Decr on non-numeric value.";
        }
    }
    ,
    BELONGS_TO_ANOTHER_SRV{

        public short fieldValue() {
            return 7;
        }

        public String errorMessage() {
            return "The vbucket belongs to another server.";
        }
    }
    ,
    AUTH_ERROR{

        public short fieldValue() {
            return 8;
        }

        public String errorMessage() {
            return "Authentication error .";
        }
    }
    ,
    AUTH_CONTINUE{

        public short fieldValue() {
            return 9;
        }

        public String errorMessage() {
            return "Authentication continue .";
        }
    }
    ,
    UNKNOWN_COMMAND{

        public short fieldValue() {
            return 129;
        }

        public String errorMessage() {
            return "Unknown command error.";
        }
    }
    ,
    OUT_OF_MEMORY{

        public short fieldValue() {
            return 130;
        }

        public String errorMessage() {
            return "Out of memory .";
        }
    }
    ,
    NOT_SUPPORTED{

        public short fieldValue() {
            return 131;
        }

        public String errorMessage() {
            return "Not supported .";
        }
    }
    ,
    INTERNAL_ERROR{

        public short fieldValue() {
            return 132;
        }

        public String errorMessage() {
            return "Internal error .";
        }
    }
    ,
    BUSY{

        public short fieldValue() {
            return 133;
        }

        public String errorMessage() {
            return "Busy.";
        }
    }
    ,
    TEMP_FAILURE{

        public short fieldValue() {
            return 134;
        }

        public String errorMessage() {
            return "Temporary failure .";
        }
    }
    ,
    AUTH_REQUIRED{

        public short fieldValue() {
            return 32;
        }

        public String errorMessage() {
            return "Authentication required or not successful";
        }
    }
    ,
    FUTHER_AUTH_REQUIRED{

        public short fieldValue() {
            return 33;
        }

        public String errorMessage() {
            return "Further authentication steps required. ";
        }
    };


    abstract short fieldValue();

    public static ResponseStatus parseShort(short value) {
        switch (value) {
            case 0: {
                return NO_ERROR;
            }
            case 1: {
                return KEY_NOT_FOUND;
            }
            case 2: {
                return KEY_EXISTS;
            }
            case 3: {
                return VALUE_TOO_BIG;
            }
            case 4: {
                return INVALID_ARGUMENTS;
            }
            case 5: {
                return ITEM_NOT_STORED;
            }
            case 6: {
                return INC_DEC_NON_NUM;
            }
            case 7: {
                return BELONGS_TO_ANOTHER_SRV;
            }
            case 8: {
                return AUTH_ERROR;
            }
            case 9: {
                return AUTH_CONTINUE;
            }
            case 129: {
                return UNKNOWN_COMMAND;
            }
            case 130: {
                return OUT_OF_MEMORY;
            }
            case 131: {
                return NOT_SUPPORTED;
            }
            case 132: {
                return INTERNAL_ERROR;
            }
            case 133: {
                return BUSY;
            }
            case 134: {
                return TEMP_FAILURE;
            }
            case 32: {
                return AUTH_REQUIRED;
            }
            case 33: {
                return FUTHER_AUTH_REQUIRED;
            }
        }
        throw new IllegalArgumentException("Unknow Response status:" + value);
    }

    abstract String errorMessage();
}

