/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextFlushAllCommand
extends Command {
    public static final ByteBuffer FLUSH_ALL = ByteBuffer.wrap("flush_all\r\n".getBytes());
    protected int exptime;

    public final int getExptime() {
        return this.exptime;
    }

    public TextFlushAllCommand(CountDownLatch latch, int delay, boolean noreply) {
        super("[flush_all]", (byte[])null, latch);
        this.commandType = CommandType.FLUSH_ALL;
        this.exptime = delay;
        this.noreply = noreply;
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        if (this.result == null) {
            byte first = buffer.get(buffer.position());
            if (first == 79) {
                this.setResult(Boolean.TRUE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 4);
            }
            return this.decodeError(session, buffer);
        }
        return ByteUtils.stepBuffer(buffer, 4);
    }

    public final void encode() {
        if (this.isNoreply()) {
            if (this.exptime <= 0) {
                this.ioBuffer = IoBuffer.allocate("flush_all".length() + 1 + Constants.NO_REPLY.length + 2);
                ByteUtils.setArguments(this.ioBuffer, "flush_all", Constants.NO_REPLY);
            } else {
                byte[] delayBytes = ByteUtils.getBytes(String.valueOf(this.exptime));
                this.ioBuffer = IoBuffer.allocate("flush_all".length() + 2 + delayBytes.length + Constants.NO_REPLY.length + 2);
                ByteUtils.setArguments(this.ioBuffer, "flush_all", delayBytes, Constants.NO_REPLY);
            }
            this.ioBuffer.flip();
        } else if (this.exptime <= 0) {
            this.ioBuffer = IoBuffer.wrap(FLUSH_ALL.slice());
        } else {
            byte[] delayBytes = ByteUtils.getBytes(String.valueOf(this.exptime));
            this.ioBuffer = IoBuffer.allocate("flush_all".length() + 1 + delayBytes.length + 2);
            ByteUtils.setArguments(this.ioBuffer, "flush_all", delayBytes);
        }
    }
}

