/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextIncrDecrCommand
extends Command {
    private long delta;
    private final long initial;

    public TextIncrDecrCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, long delta, long initial, boolean noreply) {
        super(key, keyBytes, cmdType, latch);
        this.delta = delta;
        this.noreply = noreply;
        this.initial = initial;
    }

    public final long getDelta() {
        return this.delta;
    }

    public final void setDelta(int delta) {
        this.delta = delta;
    }

    public final boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        String line = ByteUtils.nextLine(buffer);
        if (line != null) {
            if (line.equals("NOT_FOUND")) {
                this.setResult("NOT_FOUND");
                this.countDownLatch();
                return true;
            }
            String rt = line.trim();
            if (Character.isDigit(rt.charAt(0))) {
                this.setResult(Long.valueOf(rt));
                this.countDownLatch();
                return true;
            }
            return this.decodeError(line);
        }
        return false;
    }

    public final void encode() {
        byte[] cmdBytes = this.commandType == CommandType.INCR ? Constants.INCR : Constants.DECR;
        int size = 6 + this.keyBytes.length + ByteUtils.stringSize(this.getDelta()) + Constants.CRLF.length;
        if (this.isNoreply()) {
            size += 8;
        }
        byte[] buf = new byte[size];
        if (this.isNoreply()) {
            ByteUtils.setArguments(buf, 0, cmdBytes, this.keyBytes, this.getDelta(), Constants.NO_REPLY);
        } else {
            ByteUtils.setArguments(buf, 0, cmdBytes, this.keyBytes, this.getDelta());
        }
        this.ioBuffer = IoBuffer.wrap(buf);
    }
}

