/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import net.rubyeye.xmemcached.utils.InetSocketAddressWrapper;

public final class ReconnectRequest
implements Delayed {
    private InetSocketAddressWrapper inetSocketAddressWrapper;
    private int tries;
    private static final long MIN_RECONNECT_INTERVAL = 1000L;
    private static final long MAX_RECONNECT_INTERVAL = 60000L;
    private volatile long nextReconnectTimestamp;

    public ReconnectRequest(InetSocketAddressWrapper inetSocketAddressWrapper, int tries, long reconnectInterval) {
        this.setInetSocketAddressWrapper(inetSocketAddressWrapper);
        this.setTries(tries);
        reconnectInterval = this.normalInterval(reconnectInterval);
        this.nextReconnectTimestamp = System.currentTimeMillis() + reconnectInterval;
    }

    private long normalInterval(long reconnectInterval) {
        if (reconnectInterval < 1000L) {
            reconnectInterval = 1000L;
        }
        if (reconnectInterval > 60000L) {
            reconnectInterval = 60000L;
        }
        return reconnectInterval;
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.nextReconnectTimestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed o) {
        ReconnectRequest other = (ReconnectRequest)o;
        if (this.nextReconnectTimestamp > other.nextReconnectTimestamp) {
            return 1;
        }
        return -1;
    }

    public final InetSocketAddressWrapper getInetSocketAddressWrapper() {
        return this.inetSocketAddressWrapper;
    }

    public void updateNextReconnectTimeStamp(long interval) {
        interval = this.normalInterval(interval);
        this.nextReconnectTimestamp = System.currentTimeMillis() + interval;
    }

    public final void setInetSocketAddressWrapper(InetSocketAddressWrapper inetSocketAddressWrapper) {
        this.inetSocketAddressWrapper = inetSocketAddressWrapper;
    }

    public final void setTries(int tries) {
        this.tries = tries;
    }

    public final int getTries() {
        return this.tries;
    }
}

