/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.monitor;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMemcachedMbeanServer {
    private static final Logger log = LoggerFactory.getLogger(XMemcachedMbeanServer.class);
    private MBeanServer mbserver = null;
    private static XMemcachedMbeanServer instance = new XMemcachedMbeanServer();
    private JMXConnectorServer connectorServer;
    private Thread shutdownHookThread;
    private volatile boolean isHutdownHookCalled = false;

    private XMemcachedMbeanServer() {
        this.initialize();
    }

    private void initialize() {
        block8: {
            if (this.mbserver != null && this.connectorServer != null && this.connectorServer.isActive()) {
                return;
            }
            String hostName = null;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostName = addr.getHostName();
            }
            catch (IOException e) {
                log.error("Get HostName Error", (Throwable)e);
                hostName = "localhost";
            }
            String host = System.getProperty("hostName", hostName);
            try {
                boolean enableJMX = Boolean.parseBoolean(System.getProperty("xmemcached.jmx.enable", "false"));
                if (!enableJMX) break block8;
                this.mbserver = ManagementFactory.getPlatformMBeanServer();
                int port = Integer.parseInt(System.getProperty("xmemcached.rmi.port", "7077"));
                String rmiName = System.getProperty("xmemcached.rmi.name", "xmemcachedServer");
                Registry registry = null;
                try {
                    registry = LocateRegistry.getRegistry(port);
                    registry.list();
                }
                catch (Exception e) {
                    registry = null;
                }
                if (null == registry) {
                    registry = LocateRegistry.createRegistry(port);
                }
                registry.list();
                String serverURL = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/" + rmiName;
                JMXServiceURL url = new JMXServiceURL(serverURL);
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbserver);
                this.connectorServer.start();
                this.shutdownHookThread = new Thread(){

                    public void run() {
                        try {
                            XMemcachedMbeanServer.this.isHutdownHookCalled = true;
                            if (XMemcachedMbeanServer.this.connectorServer.isActive()) {
                                XMemcachedMbeanServer.this.connectorServer.stop();
                                log.warn("JMXConnector stop");
                            }
                        }
                        catch (IOException e) {
                            log.error("Shutdown Xmemcached MBean server error", (Throwable)e);
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
                log.warn("jmx url: " + serverURL);
            }
            catch (Exception e) {
                log.error("create MBServer error", (Throwable)e);
            }
        }
    }

    public static XMemcachedMbeanServer getInstance() {
        return instance;
    }

    public final void shutdown() {
        try {
            if (this.connectorServer != null && this.connectorServer.isActive()) {
                this.connectorServer.stop();
                log.warn("JMXConnector stop");
                if (!this.isHutdownHookCalled) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
                }
            }
        }
        catch (IOException e) {
            log.error("Shutdown Xmemcached MBean server error", (Throwable)e);
        }
    }

    public boolean isRegistered(String name) {
        try {
            return this.mbserver != null && this.mbserver.isRegistered(new ObjectName(name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isActive() {
        return this.mbserver != null && this.connectorServer != null && this.connectorServer.isActive();
    }

    public int getMBeanCount() {
        if (this.mbserver != null) {
            return this.mbserver.getMBeanCount();
        }
        return 0;
    }

    public void registMBean(Object o, String name) {
        if (this.isRegistered(name)) {
            return;
        }
        if (this.mbserver != null) {
            try {
                this.mbserver.registerMBean(o, new ObjectName(name));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

