/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResource;
import org.apache.catalina.webresources.JarResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JarWarResource
extends AbstractArchiveResource {
    private static final Log log = LogFactory.getLog(JarResource.class);
    private final String archivePath;

    public JarWarResource(WebResourceRoot root, String webAppPath, String base, String baseUrl, JarEntry jarEntry, String archivePath, String internalPath, Manifest manifest) {
        super(root, webAppPath, base, "jar:war:" + baseUrl + "^/" + archivePath, jarEntry, internalPath, manifest);
        this.archivePath = archivePath;
    }

    @Override
    protected AbstractArchiveResource.JarInputStreamWrapper getJarInputStreamWrapper() {
        try {
            JarFile warFile = new JarFile(this.getBase());
            JarEntry jarFileInWar = warFile.getJarEntry(this.archivePath);
            InputStream isInWar = warFile.getInputStream(jarFileInWar);
            JarInputStream jarIs = new JarInputStream(isInWar);
            JarEntry entry = jarIs.getNextJarEntry();
            while (entry != null && !entry.getName().equals(this.getResource().getName())) {
                entry = jarIs.getNextJarEntry();
            }
            if (entry == null) {
                try {
                    jarIs.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    warFile.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return null;
            }
            return new AbstractArchiveResource.JarInputStreamWrapper(warFile, entry, jarIs);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("fileResource.getInputStreamFail", this.getResource().getName(), this.getBaseUrl()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

