/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.FieldOrMethod;
import org.apache.tomcat.util.bcel.classfile.JavaClass;

public final class ClassParser {
    private static final int MAGIC = -889275714;
    private DataInputStream file;
    private String file_name;
    private int class_name_index;
    private int superclass_name_index;
    private int access_flags;
    private int[] interfaces;
    private ConstantPool constant_pool;
    private FieldOrMethod[] fields;
    private FieldOrMethod[] methods;
    private Attribute[] attributes;
    private static final int BUFSIZE = 8192;

    public ClassParser(InputStream file, String file_name) {
        this.file_name = file_name;
        this.file = file instanceof DataInputStream ? (DataInputStream)file : new DataInputStream(new BufferedInputStream(file, 8192));
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.access_flags, this.constant_pool, this.interfaces, this.attributes);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int attributes_count = this.file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(this.file, this.constant_pool);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.access_flags = this.file.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class " + this.file_name + " can't be both final and abstract");
        }
        this.class_name_index = this.file.readUnsignedShort();
        this.superclass_name_index = this.file.readUnsignedShort();
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constant_pool = new ConstantPool(this.file);
    }

    private void readFields() throws IOException, ClassFormatException {
        int fields_count = this.file.readUnsignedShort();
        this.fields = new FieldOrMethod[fields_count];
        for (int i = 0; i < fields_count; ++i) {
            this.fields[i] = new FieldOrMethod(this.file, this.constant_pool);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.file.readInt() != -889275714) {
            throw new ClassFormatException(this.file_name + " is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int interfaces_count = this.file.readUnsignedShort();
        this.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            this.interfaces[i] = this.file.readUnsignedShort();
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int methods_count = this.file.readUnsignedShort();
        this.methods = new FieldOrMethod[methods_count];
        for (int i = 0; i < methods_count; ++i) {
            this.methods[i] = new FieldOrMethod(this.file, this.constant_pool);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        this.file.readUnsignedShort();
        this.file.readUnsignedShort();
    }
}

