/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.WriteListener;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.MediaType;
import org.apache.tomcat.util.res.StringManager;

public final class Response {
    private static final StringManager sm = StringManager.getManager("org.apache.coyote");
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    protected int status = 200;
    protected String message = null;
    protected final MimeHeaders headers = new MimeHeaders();
    protected OutputBuffer outputBuffer;
    protected final Object[] notes = new Object[32];
    protected boolean commited = false;
    public ActionHook hook;
    protected String contentType = null;
    protected String contentLanguage = null;
    protected String characterEncoding = "ISO-8859-1";
    protected long contentLength = -1L;
    private Locale locale = DEFAULT_LOCALE;
    private long contentWritten = 0L;
    private long commitTime = -1L;
    protected Exception errorException = null;
    protected boolean charsetSet = false;
    protected Request req;
    protected volatile WriteListener listener;
    private boolean fireListener = false;
    private boolean registeredForWrite = false;
    private final Object nonBlockingStateLock = new Object();

    public Request getRequest() {
        return this.req;
    }

    public void setRequest(Request req) {
        this.req = req;
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public ActionHook getHook() {
        return this.hook;
    }

    public void setHook(ActionHook hook) {
        this.hook = hook;
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public void action(ActionCode actionCode, Object param) {
        if (this.hook != null) {
            if (param == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, param);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void setCommitted(boolean v) {
        if (v && !this.commited) {
            this.commitTime = System.currentTimeMillis();
        }
        this.commited = v;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public void reset() throws IllegalStateException {
        if (this.commited) {
            throw new IllegalStateException();
        }
        this.recycle();
        this.action(ActionCode.RESET, this);
    }

    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public void setHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    public void addHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                long cL = Long.parseLong(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    public void sendHeaders() {
        this.action(ActionCode.COMMIT, this);
        this.setCommitted(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String country = locale.getCountry();
            StringBuilder value = new StringBuilder(this.contentLanguage);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.charsetSet = true;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String type) {
        if (type == null) {
            this.contentType = null;
            return;
        }
        MediaType m = null;
        try {
            m = MediaType.parseMediaType(new StringReader(type));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (m == null) {
            this.contentType = type;
            return;
        }
        this.contentType = m.toStringNoCharset();
        String charsetValue = m.getCharset();
        if (charsetValue != null && (charsetValue = charsetValue.trim()).length() > 0) {
            this.charsetSet = true;
            this.characterEncoding = charsetValue;
        }
    }

    public void setContentTypeNoCharset(String type) {
        this.contentType = type;
    }

    public String getContentType() {
        String ret = this.contentType;
        if (ret != null && this.characterEncoding != null && this.charsetSet) {
            ret = ret + ";charset=" + this.characterEncoding;
        }
        return ret;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        long length = this.getContentLengthLong();
        if (length < Integer.MAX_VALUE) {
            return (int)length;
        }
        return -1;
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    public void doWrite(ByteChunk chunk) throws IOException {
        this.outputBuffer.doWrite(chunk, this);
        this.contentWritten += (long)chunk.getLength();
    }

    public void recycle() {
        this.contentType = null;
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.characterEncoding = "ISO-8859-1";
        this.charsetSet = false;
        this.contentLength = -1L;
        this.status = 200;
        this.message = null;
        this.commited = false;
        this.commitTime = -1L;
        this.errorException = null;
        this.headers.clear();
        this.listener = null;
        this.fireListener = false;
        this.registeredForWrite = false;
        this.contentWritten = 0L;
    }

    public long getContentWritten() {
        return this.contentWritten;
    }

    public long getBytesWritten(boolean flush) {
        if (flush) {
            this.action(ActionCode.CLIENT_FLUSH, this);
        }
        return this.outputBuffer.getBytesWritten();
    }

    public WriteListener getWriteListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteListener(WriteListener listener) {
        if (listener == null) {
            throw new NullPointerException(sm.getString("response.nullWriteListener"));
        }
        if (this.getWriteListener() != null) {
            throw new IllegalStateException(sm.getString("response.writeListenerSet"));
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.action(ActionCode.ASYNC_IS_ASYNC, result);
        if (!result.get()) {
            throw new IllegalStateException(sm.getString("response.notAsync"));
        }
        this.listener = listener;
        if (this.isReady()) {
            this.action(ActionCode.DISPATCH_WRITE, null);
            Object object = this.nonBlockingStateLock;
            synchronized (object) {
                this.fireListener = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException("not in non blocking mode.");
        }
        boolean ready = false;
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            if (this.registeredForWrite) {
                this.fireListener = true;
                return false;
            }
            ready = this.checkRegisterForWrite(false);
            this.fireListener = !ready;
        }
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRegisterForWrite(boolean internal) {
        AtomicBoolean ready = new AtomicBoolean(false);
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            if (!this.registeredForWrite || internal) {
                this.action(ActionCode.NB_WRITE_INTEREST, ready);
                this.registeredForWrite = !ready.get();
            }
        }
        return ready.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWritePossible() throws IOException {
        boolean fire = false;
        Object object = this.nonBlockingStateLock;
        synchronized (object) {
            this.registeredForWrite = false;
            if (this.fireListener) {
                this.fireListener = false;
                fire = true;
            }
        }
        if (fire) {
            this.listener.onWritePossible();
        }
    }
}

