/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpNioProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNioProtocol
extends AbstractAjpProtocol<NioChannel> {
    private static final Log log = LogFactory.getLog(AjpNioProtocol.class);
    private final AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpNioProtocol() {
        this.endpoint = new NioEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((NioEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((NioEndpoint)this.endpoint).setUseSendfile(false);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-nio";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<NioChannel, AjpNioProcessor>
    implements NioEndpoint.Handler {
        protected final AjpNioProtocol proto;

        public AjpConnectionHandler(AjpNioProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<NioChannel> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void release(SocketChannel socket) {
            if (log.isDebugEnabled()) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpnioprotocol.releaseStart", socket));
            }
            boolean released = false;
            Iterator it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (((NioChannel)entry.getKey()).getIOChannel() != socket) continue;
                it.remove();
                Processor result = (Processor)entry.getValue();
                result.recycle(true);
                this.unregister(result);
                released = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpnioprotocol.releaseEnd", socket, released));
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socket) {
            Processor processor = (Processor)this.connections.remove(socket.getSocket());
            if (processor != null) {
                processor.recycle(true);
                this.recycledProcessors.push(processor);
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socket, Processor<NioChannel> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.push(processor);
            if (addToPoller) {
                socket.getSocket().getPoller().add(socket.getSocket());
            }
        }

        @Override
        protected AjpNioProcessor createProcessor() {
            AjpNioProcessor processor = new AjpNioProcessor(this.proto.packetSize, (NioEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.getAdapter());
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }

        @Override
        public void onCreateSSLEngine(SSLEngine engine) {
        }
    }
}

