/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.tomcat.util.bcel.Constants;
import org.apache.tomcat.util.bcel.classfile.AnnotationDefault;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.Code;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ConstantValue;
import org.apache.tomcat.util.bcel.classfile.Deprecated;
import org.apache.tomcat.util.bcel.classfile.EnclosingMethod;
import org.apache.tomcat.util.bcel.classfile.ExceptionTable;
import org.apache.tomcat.util.bcel.classfile.InnerClasses;
import org.apache.tomcat.util.bcel.classfile.LineNumberTable;
import org.apache.tomcat.util.bcel.classfile.LocalVariableTable;
import org.apache.tomcat.util.bcel.classfile.LocalVariableTypeTable;
import org.apache.tomcat.util.bcel.classfile.PMGClass;
import org.apache.tomcat.util.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.tomcat.util.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.tomcat.util.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.tomcat.util.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.tomcat.util.bcel.classfile.SourceFile;
import org.apache.tomcat.util.bcel.classfile.Utility;

public abstract class Attribute
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1514136303496688899L;
    protected int name_index;
    protected int length;
    protected ConstantPool constant_pool;

    protected Attribute(int name_index, int length, ConstantPool constant_pool) {
        this.name_index = name_index;
        this.length = length;
        this.constant_pool = constant_pool;
    }

    public static final Attribute readAttribute(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        int tag = -1;
        int name_index = file.readUnsignedShort();
        ConstantUtf8 c = (ConstantUtf8)constant_pool.getConstant(name_index, (byte)1);
        String name = c.getBytes();
        int length = file.readInt();
        for (int i = 0; i < 22; i = (int)((byte)(i + 1))) {
            if (!name.equals(Constants.ATTRIBUTE_NAMES[i])) continue;
            tag = i;
            break;
        }
        switch (tag) {
            case -1: {
                Utility.swallowUnknownAttribute(file, length);
                return null;
            }
            case 1: {
                return new ConstantValue(name_index, length, file, constant_pool);
            }
            case 0: {
                return new SourceFile(name_index, length, file, constant_pool);
            }
            case 2: {
                return new Code(name_index, length, file, constant_pool);
            }
            case 3: {
                return new ExceptionTable(name_index, length, file, constant_pool);
            }
            case 4: {
                return new LineNumberTable(name_index, length, file, constant_pool);
            }
            case 5: {
                return new LocalVariableTable(name_index, length, file, constant_pool);
            }
            case 6: {
                return new InnerClasses(name_index, length, file, constant_pool);
            }
            case 7: {
                Utility.swallowSynthetic(file, length);
                return null;
            }
            case 8: {
                return new Deprecated(name_index, length, file, constant_pool);
            }
            case 9: {
                return new PMGClass(name_index, length, file, constant_pool);
            }
            case 10: {
                Utility.swallowSignature(file);
                return null;
            }
            case 11: {
                Utility.swallowStackMap(file);
                return null;
            }
            case 12: {
                return new RuntimeVisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 13: {
                return new RuntimeInvisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 14: {
                return new RuntimeVisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 15: {
                return new RuntimeInvisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 16: {
                return new AnnotationDefault(name_index, length, file, constant_pool);
            }
            case 17: {
                return new LocalVariableTypeTable(name_index, length, file, constant_pool);
            }
            case 18: {
                return new EnclosingMethod(name_index, length, file, constant_pool);
            }
            case 19: {
                Utility.swallowStackMapTable(file);
                return null;
            }
            case 20: {
                Utility.swallowBootstrapMethods(file);
                return null;
            }
            case 21: {
                Utility.swallowMethodParameters(file);
                return null;
            }
        }
        throw new IllegalStateException("Unrecognized attribute type tag parsed: " + tag);
    }

    public String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public Attribute clone() {
        Attribute attr = null;
        try {
            attr = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
        return attr;
    }
}

