/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.core.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureImpl<R>
implements Future<R> {
    private final Object sync;
    private boolean isDone;
    private boolean isCancelled;
    private Throwable failure;
    protected R result;

    public FutureImpl() {
        this(new Object());
    }

    public FutureImpl(Object sync) {
        this.sync = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getResult() {
        Object object = this.sync;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(R result) {
        Object object = this.sync;
        synchronized (object) {
            this.result = result;
            this.notifyHaveResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.sync;
        synchronized (object) {
            this.isCancelled = true;
            this.notifyHaveResult();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.sync;
        synchronized (object) {
            return this.isCancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.sync;
        synchronized (object) {
            return this.isDone;
        }
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        Object object = this.sync;
        synchronized (object) {
            while (true) {
                if (this.isDone) {
                    if (this.isCancelled) {
                        throw new CancellationException();
                    }
                    if (this.failure != null) {
                        throw new ExecutionException(this.failure);
                    }
                    if (this.result != null) {
                        return this.result;
                    }
                }
                this.sync.wait();
            }
        }
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long startTime = System.currentTimeMillis();
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        Object object = this.sync;
        synchronized (object) {
            while (true) {
                if (this.isDone) {
                    if (this.isCancelled) {
                        throw new CancellationException();
                    }
                    if (this.failure != null) {
                        throw new ExecutionException(this.failure);
                    }
                    if (this.result != null) {
                        return this.result;
                    }
                } else if (System.currentTimeMillis() - startTime > timeoutMillis) {
                    throw new TimeoutException();
                }
                this.sync.wait(timeoutMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable failure) {
        Object object = this.sync;
        synchronized (object) {
            this.failure = failure;
            this.notifyHaveResult();
        }
    }

    protected void notifyHaveResult() {
        this.isDone = true;
        this.sync.notifyAll();
    }
}

