/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.nio.impl;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.Handler;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.core.impl.AbstractController;
import com.google.code.yanf4j.nio.NioSessionConfig;
import com.google.code.yanf4j.nio.SelectionKeyHandler;
import com.google.code.yanf4j.nio.impl.SelectorManager;
import com.google.code.yanf4j.util.SystemUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NioController
extends AbstractController
implements SelectionKeyHandler {
    protected SelectorManager selectorManager;
    protected int selectorPoolSize = SystemUtils.getSystemThreadCount();

    public int getSelectorPoolSize() {
        return this.selectorPoolSize;
    }

    public void setSelectorPoolSize(int selectorPoolSize) {
        if (this.isStarted()) {
            throw new IllegalStateException("Controller has been started");
        }
        this.selectorPoolSize = selectorPoolSize;
    }

    public NioController() {
    }

    public NioController(Configuration configuration, CodecFactory codecFactory) {
        super(configuration, codecFactory);
    }

    public NioController(Configuration configuration, Handler handler, CodecFactory codecFactory) {
        super(configuration, handler, codecFactory);
    }

    public NioController(Configuration configuration) {
        super(configuration);
    }

    public final SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    @Override
    protected void start0() throws IOException {
        try {
            this.initialSelectorManager();
            this.doStart();
        }
        catch (IOException e) {
            log.error("Start server error", (Throwable)e);
            this.notifyException(e);
            this.stop();
            throw e;
        }
    }

    protected void initialSelectorManager() throws IOException {
        if (this.selectorManager == null) {
            this.selectorManager = new SelectorManager(this.selectorPoolSize, this, this.configuration);
            this.selectorManager.start();
        }
    }

    protected abstract void doStart() throws IOException;

    @Override
    public void onRead(SelectionKey key) {
        if (this.readEventDispatcher == null) {
            this.dispatchReadEvent(key);
        } else {
            this.readEventDispatcher.dispatch(new ReadTask(key));
        }
    }

    @Override
    public void onWrite(SelectionKey key) {
        if (this.writeEventDispatcher == null) {
            this.dispatchWriteEvent(key);
        } else {
            this.writeEventDispatcher.dispatch(new WriteTask(key));
        }
    }

    @Override
    public void closeSelectionKey(SelectionKey key) {
        Session session;
        if (key.attachment() instanceof Session && (session = (Session)key.attachment()) != null) {
            session.close();
        }
    }

    protected abstract void dispatchReadEvent(SelectionKey var1);

    protected abstract void dispatchWriteEvent(SelectionKey var1);

    @Override
    protected void stop0() throws IOException {
        if (this.selectorManager == null || !this.selectorManager.isStarted()) {
            return;
        }
        this.selectorManager.stop();
    }

    public synchronized void bind(int port) throws IOException {
        if (this.isStarted()) {
            throw new IllegalStateException("Server has been bind to " + this.getLocalSocketAddress());
        }
        this.bind(new InetSocketAddress(port));
    }

    protected final NioSessionConfig buildSessionConfig(SelectableChannel sc, Queue<WriteMessage> queue) {
        NioSessionConfig sessionConfig = new NioSessionConfig(sc, this.getHandler(), this.selectorManager, this.getCodecFactory(), this.getStatistics(), queue, this.dispatchMessageDispatcher, this.isHandleReadWriteConcurrently(), this.sessionTimeout, this.configuration.getSessionIdleTimeout());
        return sessionConfig;
    }

    private final class ReadTask
    implements Runnable {
        private final SelectionKey key;

        private ReadTask(SelectionKey key) {
            this.key = key;
        }

        public final void run() {
            NioController.this.dispatchReadEvent(this.key);
        }
    }

    private final class WriteTask
    implements Runnable {
        private final SelectionKey key;

        private WriteTask(SelectionKey key) {
            this.key = key;
        }

        public final void run() {
            NioController.this.dispatchWriteEvent(this.key);
        }
    }
}

