/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.codec;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.util.ByteBufferMatcher;
import com.google.code.yanf4j.util.ShiftAndByteBufferMatcher;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedDecoder
implements CodecFactory.Decoder {
    public static final Logger log = LoggerFactory.getLogger(MemcachedDecoder.class);
    public static final ByteBufferMatcher SPLIT_MATCHER = new ShiftAndByteBufferMatcher(IoBuffer.wrap(ByteUtils.SPLIT));

    public Object decode(IoBuffer buffer, Session origSession) {
        MemcachedTCPSession session = (MemcachedTCPSession)origSession;
        if (session.getCurrentCommand() != null) {
            return this.decode0(buffer, session);
        }
        session.takeCurrentCommand();
        if (session.getCurrentCommand() == null) {
            return null;
        }
        return this.decode0(buffer, session);
    }

    private Object decode0(IoBuffer buffer, MemcachedTCPSession session) {
        if (session.getCurrentCommand().decode(session, buffer.buf())) {
            Command command = session.getCurrentCommand();
            session.setCurrentCommand(null);
            return command;
        }
        return null;
    }
}

