/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.ServerAddressAware;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.transcoders.CachedData;

public class BinaryVersionCommand
extends BaseBinaryCommand
implements ServerAddressAware {
    public InetSocketAddress server;

    public final InetSocketAddress getServer() {
        return this.server;
    }

    public final void setServer(InetSocketAddress server) {
        this.server = server;
    }

    public BinaryVersionCommand(CountDownLatch latch, InetSocketAddress server) {
        super("[version]", null, CommandType.VERSION, latch, 0, 0L, latch, false, null);
        this.commandType = CommandType.VERSION;
        this.server = server;
        this.opCode = OpCode.VERSION;
    }

    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        int valueLength = bodyLength - keyLength - extrasLength;
        if (buffer.remaining() < valueLength) {
            return false;
        }
        byte[] bytes = new byte[valueLength];
        buffer.get(bytes);
        this.setResult(new String(bytes));
        this.countDownLatch();
        return true;
    }

    protected void fillExtras(CachedData data) {
    }

    protected void fillValue(CachedData data) {
    }

    protected byte getExtrasLength() {
        return 0;
    }

    protected void fillKey() {
    }

    protected int getKeyLength() {
        return 0;
    }

    protected int getValueLength(CachedData data) {
        return 0;
    }
}

