/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.text.TextStoreCommand;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextCASCommand
extends TextStoreCommand {
    private FailStatus failStatus;

    public TextCASCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, int exp, long cas, Object value, boolean noreply, Transcoder transcoder) {
        super(key, keyBytes, cmdType, latch, exp, cas, value, noreply, transcoder);
    }

    public final boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        if (this.result == null) {
            if (buffer.remaining() < 2) {
                return false;
            }
            byte first = buffer.get(buffer.position());
            byte second = buffer.get(buffer.position() + 1);
            if (first == 83 && second == 84) {
                this.setResult(Boolean.TRUE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 8);
            }
            if (first == 78) {
                this.setResult(Boolean.FALSE);
                this.countDownLatch();
                this.failStatus = FailStatus.NOT_FOUND;
                return ByteUtils.stepBuffer(buffer, 11);
            }
            if (first == 69 && second == 88) {
                this.setResult(Boolean.FALSE);
                this.countDownLatch();
                this.failStatus = FailStatus.EXISTS;
                return ByteUtils.stepBuffer(buffer, 8);
            }
            return this.decodeError(session, buffer);
        }
        Boolean result = (Boolean)this.result;
        if (result.booleanValue()) {
            return ByteUtils.stepBuffer(buffer, 8);
        }
        switch (this.failStatus) {
            case NOT_FOUND: {
                return ByteUtils.stepBuffer(buffer, 11);
            }
            case EXISTS: {
                return ByteUtils.stepBuffer(buffer, 8);
            }
        }
        return this.decodeError(session, buffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FailStatus {
        NOT_FOUND,
        EXISTS;

    }
}

