/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.core.impl.HandlerAdapter;
import com.google.code.yanf4j.util.SystemUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.auth.AuthMemcachedConnectListener;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.MapReturnValueAware;
import net.rubyeye.xmemcached.command.OperationStatus;
import net.rubyeye.xmemcached.command.binary.BinaryGetCommand;
import net.rubyeye.xmemcached.command.binary.BinaryVersionCommand;
import net.rubyeye.xmemcached.command.text.TextGetOneCommand;
import net.rubyeye.xmemcached.command.text.TextVersionCommand;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.impl.ReconnectRequest;
import net.rubyeye.xmemcached.monitor.StatisticsHandler;
import net.rubyeye.xmemcached.networking.MemcachedSessionConnectListener;
import net.rubyeye.xmemcached.utils.InetSocketAddressWrapper;
import net.rubyeye.xmemcached.utils.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedHandler
extends HandlerAdapter {
    private final StatisticsHandler statisticsHandler;
    private ExecutorService heartBeatThreadPool;
    private final MemcachedSessionConnectListener listener;
    private final MemcachedClient client;
    private static final Logger log = LoggerFactory.getLogger(MemcachedHandler.class);
    private final ScheduledExecutorService scheduleExecutorService;
    private volatile boolean enableHeartBeat = true;
    private static final String HEART_BEAT_FAIL_COUNT_ATTR = "heartBeatFailCount";
    private static final int MAX_HEART_BEAT_FAIL_COUNT = 5;
    final long HEARTBEAT_PERIOD = Long.parseLong(System.getProperty("xmemcached.heartbeat.period", "5000"));

    public final void onMessageReceived(Session session, Object msg) {
        Command command = (Command)msg;
        if (this.statisticsHandler.isStatistics()) {
            if (command.getMergeCount() > 0) {
                int size = ((MapReturnValueAware)((Object)command)).getReturnValues().size();
                this.statisticsHandler.statistics(CommandType.GET_HIT, size);
                this.statisticsHandler.statistics(CommandType.GET_MISS, command.getMergeCount() - size);
            } else if (command instanceof TextGetOneCommand || command instanceof BinaryGetCommand) {
                if (command.getResult() != null) {
                    this.statisticsHandler.statistics(CommandType.GET_HIT);
                } else {
                    this.statisticsHandler.statistics(CommandType.GET_MISS);
                }
            } else {
                this.statisticsHandler.statistics(command.getCommandType());
            }
        }
    }

    public void setEnableHeartBeat(boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }

    public final void onMessageSent(Session session, Object msg) {
        Command command = (Command)msg;
        command.setStatus(OperationStatus.SENT);
        if (!command.isNoreply() || this.client.getProtocol() == Protocol.Binary) {
            ((MemcachedTCPSession)session).addCommand(command);
        }
    }

    public void onExceptionCaught(Session session, Throwable throwable) {
        log.error("XMemcached network layout exception", throwable);
    }

    public void onSessionStarted(Session session) {
        session.setUseBlockingRead(true);
        session.setAttribute(HEART_BEAT_FAIL_COUNT_ATTR, new AtomicInteger(0));
        for (MemcachedClientStateListener listener : this.client.getStateListeners()) {
            listener.onConnected(this.client, session.getRemoteSocketAddress());
        }
        this.listener.onConnect((MemcachedTCPSession)session, this.client);
    }

    public final void onSessionClosed(Session session) {
        this.client.getConnector().removeSession(session);
        MemcachedTCPSession memcachedSession = (MemcachedTCPSession)session;
        memcachedSession.destroy();
        if (this.client.getConnector().isStarted() && memcachedSession.isAllowReconnect()) {
            this.reconnect(memcachedSession);
        }
        for (MemcachedClientStateListener listener : this.client.getStateListeners()) {
            listener.onDisconnected(this.client, session.getRemoteSocketAddress());
        }
    }

    public void onSessionIdle(Session session) {
    }

    private void checkHeartBeat(Session session) {
        log.debug("Check session (%s) is alive,send heartbeat", (Object)(session.getRemoteSocketAddress() == null ? "unknown" : SystemUtils.getRawAddress(session.getRemoteSocketAddress()) + ":" + session.getRemoteSocketAddress().getPort()));
        Command versionCommand = null;
        CountDownLatch latch = new CountDownLatch(1);
        versionCommand = this.client.getProtocol() == Protocol.Binary ? new BinaryVersionCommand(latch, session.getRemoteSocketAddress()) : new TextVersionCommand(latch, session.getRemoteSocketAddress());
        session.write(versionCommand);
        if (this.heartBeatThreadPool != null) {
            this.heartBeatThreadPool.execute(new CheckHeartResultThread(versionCommand, session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnect(MemcachedTCPSession session) {
        if (!this.client.isShutdown()) {
            MemcachedTCPSession memcachedTCPSession = session;
            synchronized (memcachedTCPSession) {
                if (!session.isAllowReconnect()) {
                    return;
                }
                session.setAllowReconnect(false);
            }
            MemcachedTCPSession memcachedTCPSession2 = session;
            InetSocketAddressWrapper inetSocketAddressWrapper = memcachedTCPSession2.getInetSocketAddressWrapper();
            this.client.getConnector().addToWatingQueue(new ReconnectRequest(inetSocketAddressWrapper, 0, this.client.getHealSessionInterval()));
        }
    }

    public void stop() {
        this.heartBeatThreadPool.shutdown();
        this.scheduleExecutorService.shutdown();
    }

    public void start() {
        int serverSize = this.client.getAvaliableServers().size();
        this.heartBeatThreadPool = Executors.newFixedThreadPool(serverSize == 0 ? Runtime.getRuntime().availableProcessors() : serverSize);
        this.scheduleExecutorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                if (MemcachedHandler.this.enableHeartBeat) {
                    for (Session session : MemcachedHandler.this.client.getConnector().getSessionSet()) {
                        MemcachedHandler.this.checkHeartBeat(session);
                    }
                }
            }
        }, this.HEARTBEAT_PERIOD, this.HEARTBEAT_PERIOD, TimeUnit.MILLISECONDS);
    }

    public MemcachedHandler(MemcachedClient client) {
        this.client = client;
        this.listener = new AuthMemcachedConnectListener();
        this.statisticsHandler = new StatisticsHandler();
        this.scheduleExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    static final class CheckHeartResultThread
    implements Runnable {
        private final Command versionCommand;
        private final Session session;

        public CheckHeartResultThread(Command versionCommand, Session session) {
            this.versionCommand = versionCommand;
            this.session = session;
        }

        public void run() {
            try {
                AtomicInteger heartBeatFailCount = (AtomicInteger)this.session.getAttribute(MemcachedHandler.HEART_BEAT_FAIL_COUNT_ATTR);
                if (heartBeatFailCount != null) {
                    if (!this.versionCommand.getLatch().await(2000L, TimeUnit.MILLISECONDS)) {
                        heartBeatFailCount.incrementAndGet();
                    }
                    if (this.versionCommand.getResult() == null) {
                        heartBeatFailCount.incrementAndGet();
                    } else {
                        heartBeatFailCount.set(0);
                    }
                    if (heartBeatFailCount.get() > 5) {
                        log.warn("Session(" + SystemUtils.getRawAddress(this.session.getRemoteSocketAddress()) + ":" + this.session.getRemoteSocketAddress().getPort() + ") heartbeat fail 10 times,close session and try to heal it");
                        this.session.close();
                        heartBeatFailCount.set(0);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

