/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinMemcachedSessionLocator
implements MemcachedSessionLocator {
    private volatile transient List<Session> sessions;
    private AtomicInteger sets = new AtomicInteger(0);

    @Override
    public Session getSessionByKey(String key) {
        List<Session> copyList = this.sessions;
        if (copyList == null || copyList.isEmpty()) {
            return null;
        }
        int size = copyList.size();
        return copyList.get(Math.abs(this.sets.getAndIncrement()) % size);
    }

    @Override
    public final void updateSessions(Collection<Session> list) {
        Collection<Session> copySessions = list;
        ArrayList<Session> newSessions = new ArrayList<Session>(copySessions.size() * 2);
        for (Session session : copySessions) {
            if (session instanceof MemcachedTCPSession) {
                int weight = ((MemcachedSession)session).getWeight();
                for (int i = 0; i < weight; ++i) {
                    newSessions.add(session);
                }
                continue;
            }
            newSessions.add(session);
        }
        this.sessions = newSessions;
    }

    @Override
    public void setFailureMode(boolean failureMode) {
    }
}

