/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.List;

public class Utils {
    public static boolean VERBOSE_TESTS = false;

    public static boolean isDebugVM() {
        boolean debugMode = false;
        List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String s : l) {
            if (!s.trim().startsWith("-Xrunjdwp:") && !s.contains("jdwp")) continue;
            debugMode = true;
            break;
        }
        return debugMode;
    }

    public static void dumpOut(Object text) {
        if (VERBOSE_TESTS) {
            System.out.println(text);
        }
    }

    public static void dumpErr(Object text) {
        if (VERBOSE_TESTS) {
            System.err.println(text);
        }
    }

    public static byte[] copy(byte[] src) {
        byte[] copy = null;
        if (src != null) {
            copy = new byte[src.length];
            System.arraycopy(src, 0, copy, 0, src.length);
        }
        return copy;
    }

    public static String byteBuffer2String(ByteBuffer bb) {
        return new String(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
    }
}

