/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Builder;
import redis.clients.jedis.Tuple;
import redis.clients.util.SafeEncoder;

public class BuilderFactory {
    public static final Builder<Double> DOUBLE = new Builder<Double>(){

        @Override
        public Double build(Object data) {
            String asString = STRING.build(data);
            return asString == null ? null : Double.valueOf(asString);
        }

        public String toString() {
            return "double";
        }
    };
    public static final Builder<Boolean> BOOLEAN = new Builder<Boolean>(){

        @Override
        public Boolean build(Object data) {
            return (Long)data == 1L;
        }

        public String toString() {
            return "boolean";
        }
    };
    public static final Builder<byte[]> BYTE_ARRAY = new Builder<byte[]>(){

        @Override
        public byte[] build(Object data) {
            return (byte[])data;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<Long> LONG = new Builder<Long>(){

        @Override
        public Long build(Object data) {
            return (Long)data;
        }

        public String toString() {
            return "long";
        }
    };
    public static final Builder<String> STRING = new Builder<String>(){

        @Override
        public String build(Object data) {
            return data == null ? null : SafeEncoder.encode((byte[])data);
        }

        public String toString() {
            return "string";
        }
    };
    public static final Builder<List<String>> STRING_LIST = new Builder<List<String>>(){

        @Override
        public List<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            ArrayList<String> result = new ArrayList<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "List<String>";
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List flatHash = (List)data;
            HashMap<String, String> hash = new HashMap<String, String>();
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next()));
            }
            return hash;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<Set<String>> STRING_SET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            HashSet<String> result = new HashSet<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<List<byte[]>> BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        @Override
        public List<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            return l;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Set<byte[]>> BYTE_ARRAY_ZSET = new Builder<Set<byte[]>>(){

        @Override
        public Set<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<byte[]> result = new LinkedHashSet<byte[]>(l);
            return result;
        }

        public String toString() {
            return "ZSet<byte[]>";
        }
    };
    public static final Builder<Set<String>> STRING_ZSET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<String> result = new LinkedHashSet<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "ZSet<String>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(l.size());
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple(SafeEncoder.encode((byte[])iterator.next()), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
            }
            return result;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET_BINARY = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(l.size());
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple((byte[])iterator.next(), Double.valueOf(SafeEncoder.encode((byte[])iterator.next()))));
            }
            return result;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
}

