/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.demo.user.facade;

import com.alibaba.dubbo.demo.user.User;
import com.alibaba.dubbo.demo.user.UserService;
import com.alibaba.dubbo.demo.user.facade.RegistrationResult;
import com.alibaba.dubbo.demo.user.facade.UserRestService;
import com.alibaba.dubbo.rpc.RpcContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="users")
@Consumes(value={"application/json", "text/xml"})
@Produces(value={"application/json; charset=UTF-8", "text/xml; charset=UTF-8"})
public class UserRestServiceImpl
implements UserRestService {
    private UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @GET
    @Path(value="{id : \\d+}")
    public User getUser(@PathParam(value="id") Long id) {
        if (RpcContext.getContext().getRequest(HttpServletRequest.class) != null) {
            System.out.println("Client IP address from RpcContext: " + ((HttpServletRequest)RpcContext.getContext().getRequest(HttpServletRequest.class)).getRemoteAddr());
        }
        if (RpcContext.getContext().getResponse(HttpServletResponse.class) != null) {
            System.out.println("Response object from RpcContext: " + RpcContext.getContext().getResponse(HttpServletResponse.class));
        }
        return this.userService.getUser(id);
    }

    @POST
    @Path(value="register")
    public RegistrationResult registerUser(User user) {
        return new RegistrationResult(this.userService.registerUser(user));
    }
}

