/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashAlgorithm
extends Enum<HashAlgorithm> {
    public static final /* enum */ HashAlgorithm NATIVE_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm CRC32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1_64_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1A_64_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1_32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1A_32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm KETAMA_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm MYSQL_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm ELF_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm RS_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm LUA_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm ELECTION_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm ONE_AT_A_TIME = new HashAlgorithm();
    private static final long FNV_64_INIT = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final long FNV_32_INIT = 2166136261L;
    private static final long FNV_32_PRIME = 16777619L;
    private static ThreadLocal<MessageDigest> md5Local;
    private static final /* synthetic */ HashAlgorithm[] $VALUES;

    public static HashAlgorithm[] values() {
        return (HashAlgorithm[])$VALUES.clone();
    }

    public static HashAlgorithm valueOf(String name) {
        return Enum.valueOf(HashAlgorithm.class, name);
    }

    public long hash(String k) {
        long rv = 0L;
        switch (this) {
            case NATIVE_HASH: {
                rv = k.hashCode();
                break;
            }
            case CRC32_HASH: {
                CRC32 crc32 = new CRC32();
                crc32.update(ByteUtils.getBytes(k));
                rv = crc32.getValue() >> 16 & 0x7FFFL;
                break;
            }
            case FNV1_64_HASH: {
                rv = -3750763034362895579L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv *= 1099511628211L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case FNV1A_64_HASH: {
                rv = -3750763034362895579L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 1099511628211L;
                }
                break;
            }
            case FNV1_32_HASH: {
                rv = 2166136261L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv *= 16777619L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case FNV1A_32_HASH: {
                rv = 2166136261L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 16777619L;
                }
                break;
            }
            case ELECTION_HASH: 
            case KETAMA_HASH: {
                byte[] bKey = HashAlgorithm.computeMd5(k);
                rv = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
                break;
            }
            case MYSQL_HASH: {
                int nr2 = 4;
                for (int i = 0; i < k.length(); ++i) {
                    rv ^= ((rv & 0x3FL) + (long)nr2) * (long)k.charAt(i) + (rv << 8);
                    nr2 += 3;
                }
                break;
            }
            case ELF_HASH: {
                long x = 0L;
                for (int i = 0; i < k.length(); ++i) {
                    x = (rv = (rv << 4) + (long)k.charAt(i)) & 0xF0000000L;
                    if (x == 0L) continue;
                    rv ^= x >> 24;
                    rv &= x ^ 0xFFFFFFFFFFFFFFFFL;
                }
                rv &= Integer.MAX_VALUE;
                break;
            }
            case RS_HASH: {
                long b = 378551L;
                long a = 63689L;
                for (int i = 0; i < k.length(); ++i) {
                    rv = rv * a + (long)k.charAt(i);
                    a *= b;
                }
                rv &= Integer.MAX_VALUE;
                break;
            }
            case LUA_HASH: {
                int step = (k.length() >> 5) + 1;
                rv = k.length();
                for (int len = k.length(); len >= step; len -= step) {
                    rv ^= (rv << 5) + (rv >> 2) + (long)k.charAt(len - 1);
                }
            }
            case ONE_AT_A_TIME: {
                try {
                    int hash = 0;
                    for (byte bt : k.getBytes("utf-8")) {
                        hash += bt & 0xFF;
                        hash += hash << 10;
                        hash ^= hash >>> 6;
                    }
                    hash += hash << 3;
                    hash ^= hash >>> 11;
                    hash += hash << 15;
                    return hash;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Hash function error", e);
                }
            }
            default: {
                assert (false);
                break;
            }
        }
        return rv & 0xFFFFFFFFL;
    }

    public static byte[] computeMd5(String k) {
        MessageDigest md5 = md5Local.get();
        if (md5 == null) {
            try {
                md5 = MessageDigest.getInstance("MD5");
                md5Local.set(md5);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 not supported", e);
            }
        }
        md5.reset();
        md5.update(ByteUtils.getBytes(k));
        return md5.digest();
    }

    static {
        $VALUES = new HashAlgorithm[]{NATIVE_HASH, CRC32_HASH, FNV1_64_HASH, FNV1A_64_HASH, FNV1_32_HASH, FNV1A_32_HASH, KETAMA_HASH, MYSQL_HASH, ELF_HASH, RS_HASH, LUA_HASH, ELECTION_HASH, ONE_AT_A_TIME};
        md5Local = new ThreadLocal();
    }
}

