/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.impl.AbstractMemcachedSessionLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibmemcachedMemcachedSessionLocator
extends AbstractMemcachedSessionLocator {
    static final int DEFAULT_NUM_REPS = 100;
    private volatile transient TreeMap<Long, List<Session>> ketamaSessions = new TreeMap();
    private volatile int maxTries;
    private int numReps = 100;
    private final Random random = new Random();
    private HashAlgorithm hashAlgorithm = HashAlgorithm.ONE_AT_A_TIME;

    public LibmemcachedMemcachedSessionLocator() {
    }

    public LibmemcachedMemcachedSessionLocator(int numReps, HashAlgorithm hashAlgorithm) {
        this.numReps = numReps;
        this.hashAlgorithm = hashAlgorithm;
    }

    private final void buildMap(Collection<Session> list, HashAlgorithm alg) {
        TreeMap<Long, List<Session>> sessionMap = new TreeMap<Long, List<Session>>();
        for (Session session : list) {
            String sockStr = null;
            sockStr = session.getRemoteSocketAddress().getPort() != 11211 ? session.getRemoteSocketAddress().getHostName() + ":" + session.getRemoteSocketAddress().getPort() : session.getRemoteSocketAddress().getHostName();
            for (int i = 0; i < this.numReps; ++i) {
                long key = this.hashAlgorithm.hash(sockStr + "-" + i);
                this.getSessionList(sessionMap, key).add(session);
            }
        }
        this.ketamaSessions = sessionMap;
        this.maxTries = list.size();
    }

    private List<Session> getSessionList(TreeMap<Long, List<Session>> sessionMap, long k) {
        List<Session> sessionList = sessionMap.get(k);
        if (sessionList == null) {
            sessionList = new ArrayList<Session>();
            sessionMap.put(k, sessionList);
        }
        return sessionList;
    }

    @Override
    public final Session getSessionByKey(String key) {
        if (this.ketamaSessions == null || this.ketamaSessions.size() == 0) {
            return null;
        }
        long hash = this.hashAlgorithm.hash(key);
        Session rv = this.getSessionByHash(hash);
        int tries = 0;
        while (!this.failureMode && (rv == null || rv.isClosed()) && tries++ < this.maxTries) {
            hash = this.nextHash(hash, key, tries);
            rv = this.getSessionByHash(hash);
        }
        return rv;
    }

    public final Session getSessionByHash(long hash) {
        List<Session> sessionList;
        TreeMap<Long, List<Session>> sessionMap = this.ketamaSessions;
        if (sessionMap.size() == 0) {
            return null;
        }
        Long resultHash = hash;
        if (!sessionMap.containsKey(hash)) {
            SortedMap<Long, List<Session>> tailMap = sessionMap.tailMap(hash);
            resultHash = tailMap.isEmpty() ? sessionMap.firstKey() : tailMap.firstKey();
        }
        if ((sessionList = sessionMap.get(resultHash)) == null || sessionList.size() == 0) {
            return null;
        }
        int size = sessionList.size();
        return sessionList.get(this.random.nextInt(size));
    }

    public final long nextHash(long hashVal, String key, int tries) {
        long tmpKey = this.hashAlgorithm.hash(tries + key);
        hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
        return hashVal &= 0xFFFFFFFFL;
    }

    @Override
    public final void updateSessions(Collection<Session> list) {
        this.buildMap(list, null);
    }
}

