/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple.pages;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.container.page.Page;
import com.alibaba.dubbo.container.page.PageHandler;
import com.alibaba.dubbo.monitor.simple.CountUtils;
import com.alibaba.dubbo.monitor.simple.SimpleMonitorService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsPageHandler
implements PageHandler {
    public Page handle(URL url) {
        String service = url.getParameter("service");
        if (service == null || service.length() == 0) {
            throw new IllegalArgumentException("Please input service parameter.");
        }
        String date = url.getParameter("date");
        if (date == null || date.length() == 0) {
            date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        }
        String expand = url.getParameter("expand");
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        String directory = SimpleMonitorService.getInstance().getStatisticsDirectory();
        String filename = directory + "/" + date + "/" + service;
        File serviceDir = new File(filename);
        if (serviceDir.exists()) {
            File[] methodDirs;
            for (File methodDir : methodDirs = serviceDir.listFiles()) {
                File[] consumerDirs;
                long[] statistics = this.newStatistics();
                HashMap<String, long[]> expandMap = new HashMap<String, long[]>();
                for (File consumerDir : consumerDirs = methodDir.listFiles()) {
                    File[] providerDirs;
                    long[] expandStatistics = null;
                    if ("consumer".equals(expand)) {
                        expandStatistics = this.newStatistics();
                        expandMap.put(consumerDir.getName(), expandStatistics);
                    }
                    for (File providerDir : providerDirs = consumerDir.listFiles()) {
                        if ("provider".equals(expand)) {
                            expandStatistics = this.newStatistics();
                            expandMap.put(providerDir.getName(), expandStatistics);
                        }
                        this.appendStatistics(providerDir, statistics);
                        if (expandStatistics == null) continue;
                        this.appendStatistics(providerDir, expandStatistics);
                    }
                }
                rows.add(this.toRow(methodDir.getName(), statistics));
                if (expandMap == null || expandMap.size() <= 0) continue;
                for (Map.Entry entry : expandMap.entrySet()) {
                    String node = "consumer".equals(expand) ? "&lt;--" : "--&gt;";
                    rows.add(this.toRow(" &nbsp;&nbsp;&nbsp;&nbsp; |" + node + " " + (String)entry.getKey(), (long[])entry.getValue()));
                }
            }
        }
        StringBuilder nav = new StringBuilder();
        nav.append("<a href=\"services.html\">Services</a> &gt; ");
        nav.append(service);
        nav.append(" &gt; <a href=\"providers.html?service=");
        nav.append(service);
        nav.append("\">Providers</a> | <a href=\"consumers.html?service=");
        nav.append(service);
        nav.append("\">Consumers</a> | Statistics | <a href=\"charts.html?service=");
        nav.append(service);
        nav.append("&date=");
        nav.append(date);
        nav.append("\">Charts</a> &gt; <input type=\"text\" style=\"width: 65px;\" name=\"date\" value=\"");
        nav.append(date);
        nav.append("\" onkeyup=\"if (event.keyCode == 10 || event.keyCode == 13) {window.location.href='statistics.html?service=");
        nav.append(service);
        if (expand != null && expand.length() > 0) {
            nav.append("&expand=");
            nav.append(expand);
        }
        nav.append("&date=' + this.value;}\" /> &gt; ");
        if (!"provider".equals(expand) && !"consumer".equals(expand)) {
            nav.append("Summary");
        } else {
            nav.append("<a href=\"statistics.html?service=");
            nav.append(service);
            nav.append("&date=");
            nav.append(date);
            nav.append("\">Summary</a>");
        }
        if ("provider".equals(expand)) {
            nav.append(" | +Provider");
        } else {
            nav.append(" | <a href=\"statistics.html?service=");
            nav.append(service);
            nav.append("&date=");
            nav.append(date);
            nav.append("&expand=provider\">+Provider</a>");
        }
        if ("consumer".equals(expand)) {
            nav.append(" | +Consumer");
        } else {
            nav.append(" | <a href=\"statistics.html?service=");
            nav.append(service);
            nav.append("&date=");
            nav.append(date);
            nav.append("&expand=consumer\">+Consumer</a>");
        }
        return new Page(nav.toString(), "Statistics (" + rows.size() + ")", new String[]{"Method:", "Success", "Failure", "Avg Elapsed (ms)", "Max Elapsed (ms)", "Max Concurrent"}, rows);
    }

    private long[] newStatistics() {
        return new long[10];
    }

    private void appendStatistics(File providerDir, long[] statistics) {
        statistics[0] = statistics[0] + CountUtils.sum(new File(providerDir, "consumer.success"));
        statistics[1] = statistics[1] + CountUtils.sum(new File(providerDir, "provider.success"));
        statistics[2] = statistics[2] + CountUtils.sum(new File(providerDir, "consumer.failure"));
        statistics[3] = statistics[3] + CountUtils.sum(new File(providerDir, "provider.failure"));
        statistics[4] = statistics[4] + CountUtils.sum(new File(providerDir, "consumer.elapsed"));
        statistics[5] = statistics[5] + CountUtils.sum(new File(providerDir, "provider.elapsed"));
        statistics[6] = Math.max(statistics[6], CountUtils.max(new File(providerDir, "consumer.max.elapsed")));
        statistics[7] = Math.max(statistics[7], CountUtils.max(new File(providerDir, "provider.max.elapsed")));
        statistics[8] = Math.max(statistics[8], CountUtils.max(new File(providerDir, "consumer.max.concurrent")));
        statistics[9] = Math.max(statistics[9], CountUtils.max(new File(providerDir, "provider.max.concurrent")));
    }

    private List<String> toRow(String name, long[] statistics) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(name);
        row.add(String.valueOf(statistics[0]) + " --&gt; " + String.valueOf(statistics[1]));
        row.add(String.valueOf(statistics[2]) + " --&gt; " + String.valueOf(statistics[3]));
        row.add(String.valueOf(statistics[0] == 0L ? 0L : statistics[4] / statistics[0]) + " --&gt; " + String.valueOf(statistics[1] == 0L ? 0L : statistics[5] / statistics[1]));
        row.add(String.valueOf(statistics[6]) + " --&gt; " + String.valueOf(statistics[7]));
        row.add(String.valueOf(statistics[8]) + " --&gt; " + String.valueOf(statistics[9]));
        return row;
    }
}

