/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.common.comm;

import com.aliyun.common.comm.ServiceClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;

class RepeatableInputStreamEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity innerEntity;
    private InputStream content;

    public RepeatableInputStreamEntity(ServiceClient.Request request) {
        this.setChunked(false);
        String contentType = request.getHeaders().get("Content-Type");
        this.content = request.getContent();
        long contentLength = request.getContentLength();
        this.innerEntity = new InputStreamEntity(this.content, contentLength);
        this.innerEntity.setContentType(contentType);
        this.setContent(this.content);
        this.setContentType(contentType);
        this.setContentLength(request.getContentLength());
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.innerEntity.isRepeatable();
    }

    public void writeTo(OutputStream output) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.innerEntity.writeTo(output);
    }
}

