/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.model;

import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.model.ResponseHeaderOverrides;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GetObjectRequest {
    private String bucketName;
    private String key;
    private long[] range;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private ResponseHeaderOverrides responseHeaders;

    public GetObjectRequest(String bucketName, String key) {
        this.setBucketName(bucketName);
        this.setKey(key);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        this.bucketName = bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        this.key = key;
    }

    public long[] getRange() {
        return this.range;
    }

    public void setRange(long start, long end) {
        if (start < 0L && end < 0L) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("InvalidRangeValues"));
        }
        this.range = new long[]{start, end};
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> eTagList) {
        this.matchingETagConstraints = eTagList;
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> eTagList) {
        this.nonmatchingEtagConstraints = eTagList;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaders) {
        this.responseHeaders = responseHeaders;
    }
}

