/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.DefaultServiceClient;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientConfiguration;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTS;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSDataOperation;
import com.aliyun.openservices.ots.internal.OTSTableOperation;
import com.aliyun.openservices.ots.internal.OTSTransactionOperation;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.OffsetRowQueryCriteria;
import com.aliyun.openservices.ots.model.PartitionKeyType;
import com.aliyun.openservices.ots.model.PartitionKeyValue;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowListing;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.model.TableMeta;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;

public class OTSClient
implements OTS {
    private URI endpoint;
    private ServiceCredentials credentials;
    private ServiceClient client;
    private OTSTableOperation tableOp;
    private OTSTransactionOperation transactionOp;
    private OTSDataOperation dataOp;

    public OTSClient(String accessKeyId, String accessKeySecret) {
        this("http://ots.aliyuncs.com", accessKeyId, accessKeySecret, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret) {
        this(endpoint, accessKeyId, accessKeySecret, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, ClientConfiguration config) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        CodingUtils.assertStringNotNullOrEmpty(accessKeyId, "accessKeyId");
        CodingUtils.assertStringNotNullOrEmpty(accessKeySecret, "accessKeySecret");
        try {
            if (!endpoint.startsWith("http://")) {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointProtocolInvalid"));
            }
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointInvalid"), e);
        }
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret);
        this.client = new DefaultServiceClient(config != null ? config : new ClientConfiguration());
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void createTableGroup(String tableGroupName, PartitionKeyType pkType) throws OTSException, ClientException {
        this.getTableOperation().createTableGroup(tableGroupName, pkType);
    }

    @Override
    public List<String> listTableGroups() throws OTSException, ClientException {
        return this.getTableOperation().listTableGroups();
    }

    @Override
    public void deleteTableGroup(String tableGroupName) throws OTSException, ClientException {
        this.getTableOperation().deleteTableGroup(tableGroupName);
    }

    @Override
    public void createTable(TableMeta tableMeta) throws OTSException, ClientException {
        this.getTableOperation().createTable(tableMeta);
    }

    @Override
    public TableMeta getTableMeta(String tableName) throws OTSException, ClientException {
        return this.getTableOperation().getTableMeta(tableName);
    }

    @Override
    public List<String> listTables() throws OTSException, ClientException {
        return this.getTableOperation().listTables();
    }

    @Override
    public void deleteTable(String tableName) throws OTSException, ClientException {
        this.getTableOperation().deleteTable(tableName);
    }

    @Override
    public String startTransaction(String entityName, PartitionKeyValue pkValue) throws OTSException, ClientException {
        return this.getTransactionOperation().startTransaction(entityName, pkValue);
    }

    @Override
    public void commitTransaction(String transactionId) throws OTSException, ClientException {
        this.getTransactionOperation().commitTransaction(transactionId);
    }

    @Override
    public void abortTransaction(String transactionId) throws OTSException, ClientException {
        this.getTransactionOperation().abortTransaction(transactionId);
    }

    @Override
    public Row getRow(SingleRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        return this.getDataOperation().getRow(criteria, transactionId);
    }

    @Override
    public List<Row> getRowsByOffset(OffsetRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        return this.getDataOperation().getRowsByOffset(criteria, transactionId);
    }

    @Override
    public List<Row> getRowsByRange(RangeRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        return this.getDataOperation().getRowsByRange(criteria, transactionId);
    }

    @Override
    public RowListing getRowsByRange(RangeRowQueryCriteria criteria, String transactionId, String nextToken) throws OTSException, ClientException {
        return this.getDataOperation().getRowsByRange(criteria, transactionId, nextToken);
    }

    @Override
    public void putData(String tableName, RowPutChange rowChange, String transactionId) throws OTSException, ClientException {
        this.getDataOperation().putData(tableName, rowChange, transactionId);
    }

    @Override
    public void deleteData(String tableName, RowDeleteChange rowChange, String transactionId) throws OTSException, ClientException {
        this.getDataOperation().deleteData(tableName, rowChange, transactionId);
    }

    @Override
    public void batchModifyData(String tableName, Collection<RowChange> rowChanges, String transactionId) throws OTSException, ClientException {
        this.getDataOperation().batchModifyData(tableName, rowChanges, transactionId);
    }

    private OTSTableOperation getTableOperation() {
        if (this.tableOp == null) {
            this.tableOp = new OTSTableOperation(this.endpoint, this.client, this.credentials);
        }
        return this.tableOp;
    }

    private OTSTransactionOperation getTransactionOperation() {
        if (this.transactionOp == null) {
            this.transactionOp = new OTSTransactionOperation(this.endpoint, this.client, this.credentials);
        }
        return this.transactionOp;
    }

    private OTSDataOperation getDataOperation() {
        if (this.dataOp == null) {
            this.dataOp = new OTSDataOperation(this.endpoint, this.client, this.credentials);
        }
        return this.dataOp;
    }
}

