/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.HttpMesssage;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ServiceException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSErrorResponseHandler;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSRequestSigner;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.OTSValidationResponseHandler;
import com.aliyun.openservices.ots.internal.model.OTSResult;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class OTSOperation {
    private URI endpoint;
    private ServiceClient client;
    private ServiceCredentials credentials;

    public OTSOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        assert (endpoint != null && client != null && credentials != null);
        this.endpoint = endpoint;
        this.client = client;
        this.credentials = credentials;
    }

    protected <T extends OTSResult> T invoke(String otsAction, HttpMethod httpMethod, Map<String, String> parameters, Class<?> resultClass) throws OTSException, ClientException {
        RequestMessage request = this.buildRequest(otsAction, httpMethod, parameters);
        try {
            return (T)((OTSResult)this.client.sendRequest(request, this.createContext(otsAction), OTSResultParserFactory.createFactory().createResultParser(resultClass)));
        }
        catch (ServiceException e) {
            throw this.handleException(e);
        }
    }

    protected void invokeNoResult(String otsAction, HttpMethod httpMethod, Map<String, String> parameters) throws OTSException, ClientException {
        RequestMessage request = this.buildRequest(otsAction, httpMethod, parameters);
        HttpMesssage response = null;
        try {
            response = this.client.sendRequest(request, this.createContext(otsAction));
        }
        catch (ServiceException e) {
            throw this.handleException(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private ExecutionContext createContext(String otsAction) {
        ExecutionContext ec = new ExecutionContext();
        ec.setCharset("utf-8");
        ec.setSigner(new OTSRequestSigner(otsAction, this.credentials));
        ec.getResponseHandlers().add(new OTSErrorResponseHandler());
        ec.getResponseHandlers().add(new OTSValidationResponseHandler(this.credentials, otsAction));
        return ec;
    }

    private RequestMessage buildRequest(String otsAction, HttpMethod httpMethod, Map<String, String> parameters) {
        return OTSOperation.buildRequest(this.endpoint, otsAction, httpMethod, parameters, this.credentials);
    }

    private static RequestMessage buildRequest(URI endpoint, String action, HttpMethod httpMethod, Map<String, String> parameters, ServiceCredentials credentials) {
        assert (endpoint != null && action != null && httpMethod != null && credentials != null);
        if (parameters == null) {
            parameters = new LinkedHashMap<String, String>();
        }
        RequestMessage request = new RequestMessage();
        request.setMethod(httpMethod);
        request.setEndpoint(endpoint);
        request.setResourcePath(action);
        request.setParameters(parameters);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        return request;
    }

    private OTSException handleException(ServiceException e) {
        if (e instanceof OTSException) {
            return (OTSException)e;
        }
        return OTSExceptionFactory.create("\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage(), e);
    }
}

