/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.common.utils.BinaryUtil;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.RowColumn;
import com.aliyun.openservices.ots.model.RowColumnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Row")
public class Row {
    @XmlElement(name="Column")
    private List<RowColumn> resultColumns;
    private Map<String, ColumnValue> columns = new LinkedHashMap<String, ColumnValue>();

    public Map<String, ColumnValue> getColumns() throws ClientException {
        this.lazyLoadResultColumns();
        return Collections.unmodifiableMap(this.columns);
    }

    private void lazyLoadResultColumns() throws ClientException {
        if (this.resultColumns != null) {
            for (RowColumn col : this.resultColumns) {
                ColumnValue columnValue = new ColumnValue(this.decodeValue(col.Value), ColumnType.fromString(col.Value.Type));
                this.columns.put(col.Name, columnValue);
            }
            this.resultColumns = null;
        }
    }

    private String decodeValue(RowColumnValue value) {
        if (value.Encoding == null || value.Encoding.length() == 0) {
            return value.Value;
        }
        if (value.Encoding.equalsIgnoreCase("Base64")) {
            return new String(BinaryUtil.fromBase64String(value.Value));
        }
        return value.Value;
    }

    Row() {
    }
}

