/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.PrimaryKey;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.ViewMeta;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;

public class TableMeta {
    private String tableName;
    private String tableGroupName;
    private int pagingKeyLen;
    @XmlElement(name="PrimaryKey")
    private List<PrimaryKey> resultPrimaryKeys;
    private Map<String, PrimaryKeyType> primaryKeys = new LinkedHashMap<String, PrimaryKeyType>();
    @XmlElement(name="View")
    private List<ViewMeta> views = new LinkedList<ViewMeta>();

    public String getTableName() {
        return this.tableName;
    }

    @XmlElement(name="TableName")
    public void setTableName(String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }

    public String getTableGroupName() {
        return this.tableGroupName;
    }

    @XmlElement(name="TableGroupName")
    public void setTableGroupName(String tableGroupName) {
        if (tableGroupName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableGroupName);
        this.tableGroupName = tableGroupName;
    }

    public int getPagingKeyLen() {
        return this.pagingKeyLen;
    }

    @XmlElement(name="PagingKeyLen")
    public void setPagingKeyLen(int pagingKeyLen) {
        if (pagingKeyLen < 0) {
            throw new ArithmeticException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ValueLessThanZero"));
        }
        this.pagingKeyLen = pagingKeyLen;
    }

    public Map<String, PrimaryKeyType> getPrimaryKeys() {
        this.loadResultPrimaryKey();
        return Collections.unmodifiableMap(this.primaryKeys);
    }

    public void addPrimaryKey(String name, PrimaryKeyType type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(name);
        this.primaryKeys.put(name, type);
    }

    private void loadResultPrimaryKey() {
        if (this.resultPrimaryKeys != null) {
            for (PrimaryKey pk : this.resultPrimaryKeys) {
                this.primaryKeys.put(pk.Name, PrimaryKeyType.fromString(pk.Type));
            }
            this.resultPrimaryKeys = null;
        }
    }

    public List<ViewMeta> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public void addView(ViewMeta view) {
        if (view == null) {
            throw new NullPointerException();
        }
        this.views.add(view);
    }

    TableMeta() {
    }

    public TableMeta(String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }
}

