/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs;

import com.baidu.inf.iis.bcs.auth.BCSCredentials;
import com.baidu.inf.iis.bcs.auth.BCSSigner;
import com.baidu.inf.iis.bcs.handler.BucketListResponseHandler;
import com.baidu.inf.iis.bcs.handler.ObjectListResponseHandler;
import com.baidu.inf.iis.bcs.handler.ObjectMetadataResponseHandler;
import com.baidu.inf.iis.bcs.handler.ObjectResponseHandler;
import com.baidu.inf.iis.bcs.handler.PolicyResponseHandler;
import com.baidu.inf.iis.bcs.handler.VoidResponseHandler;
import com.baidu.inf.iis.bcs.http.BCSHttpClient;
import com.baidu.inf.iis.bcs.http.BCSHttpRequest;
import com.baidu.inf.iis.bcs.http.ClientConfiguration;
import com.baidu.inf.iis.bcs.http.DefaultBCSHttpRequest;
import com.baidu.inf.iis.bcs.http.MD5DigestCalculatingInputStream;
import com.baidu.inf.iis.bcs.http.RepeatableFileInputStream;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.model.BCSServiceException;
import com.baidu.inf.iis.bcs.model.BucketSummary;
import com.baidu.inf.iis.bcs.model.DownloadObject;
import com.baidu.inf.iis.bcs.model.Empty;
import com.baidu.inf.iis.bcs.model.ObjectListing;
import com.baidu.inf.iis.bcs.model.ObjectMetadata;
import com.baidu.inf.iis.bcs.model.Pair;
import com.baidu.inf.iis.bcs.model.Resource;
import com.baidu.inf.iis.bcs.model.SuperfileSubObject;
import com.baidu.inf.iis.bcs.model.X_BS_ACL;
import com.baidu.inf.iis.bcs.policy.Policy;
import com.baidu.inf.iis.bcs.request.BaiduBCSRequest;
import com.baidu.inf.iis.bcs.request.CopyObjectRequest;
import com.baidu.inf.iis.bcs.request.CreateBucketRequest;
import com.baidu.inf.iis.bcs.request.DeleteBucketRequest;
import com.baidu.inf.iis.bcs.request.DeleteObjectRequest;
import com.baidu.inf.iis.bcs.request.GenerateUrlRequest;
import com.baidu.inf.iis.bcs.request.GetBucketPolicyRequest;
import com.baidu.inf.iis.bcs.request.GetObjectMetadataRequest;
import com.baidu.inf.iis.bcs.request.GetObjectPolicyRequest;
import com.baidu.inf.iis.bcs.request.GetObjectRequest;
import com.baidu.inf.iis.bcs.request.ListBucketRequest;
import com.baidu.inf.iis.bcs.request.ListObjectRequest;
import com.baidu.inf.iis.bcs.request.PutBucketPolicyRequest;
import com.baidu.inf.iis.bcs.request.PutObjectPolicyRequest;
import com.baidu.inf.iis.bcs.request.PutObjectRequest;
import com.baidu.inf.iis.bcs.request.PutSuperfileRequest;
import com.baidu.inf.iis.bcs.request.SetObjectMetadataRequest;
import com.baidu.inf.iis.bcs.response.BaiduBCSResponse;
import com.baidu.inf.iis.bcs.utils.Constants;
import com.baidu.inf.iis.bcs.utils.Mimetypes;
import com.baidu.inf.iis.bcs.utils.ServiceUtils;
import flexjson.JSONSerializer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaiduBCS {
    private static final Log log = LogFactory.getLog(BaiduBCS.class);
    private BCSHttpClient bcsHttpClient = null;
    private BCSCredentials credentials = null;
    private String endpoint = null;

    public BaiduBCS(BCSCredentials bCSCredentials, String string) {
        this.credentials = bCSCredentials;
        this.setEndpoint(string);
        this.bcsHttpClient = new BCSHttpClient(new ClientConfiguration());
    }

    public BaiduBCS(BCSCredentials bCSCredentials, String string, ClientConfiguration clientConfiguration) {
        this.credentials = bCSCredentials;
        this.setEndpoint(string);
        this.bcsHttpClient = new BCSHttpClient(clientConfiguration);
    }

    public void setCredentials(BCSCredentials bCSCredentials) {
        this.credentials = bCSCredentials;
    }

    public BCSCredentials getCredentials() {
        return this.credentials;
    }

    public void setDefaultEncoding(String string) {
        Constants.DEFAULT_ENCODING = string;
    }

    public String getDefaultEncoding() {
        return Constants.DEFAULT_ENCODING;
    }

    public void setEndpoint(String string) {
        if (string.contains("://")) {
            throw new IllegalArgumentException("Endpoint should not contains '://'.");
        }
        this.endpoint = string;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public BaiduBCSResponse<Empty> copyObject(CopyObjectRequest copyObjectRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(copyObjectRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)copyObjectRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(copyObjectRequest.getSource().getBucket(), "The bucket parameter of source must be specified when copy an object.");
        this.assertParameterNotNull(copyObjectRequest.getSource().getObject(), "The object parameter of source must be specified when copy an object.");
        this.assertParameterNotNull(copyObjectRequest.getDest().getBucket(), "The bucket parameter of dest must be specified when copy an object.");
        this.assertParameterNotNull(copyObjectRequest.getDest().getObject(), "The object parameter of dest must be specified when copy an object.");
        log.debug((Object)("copy object, src[Bucket:" + copyObjectRequest.getSource().getBucket() + "][Object:" + copyObjectRequest.getSource().getObject() + "] to dest[Bucket" + copyObjectRequest.getDest().getBucket() + "][Object" + copyObjectRequest.getDest().getObject() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(copyObjectRequest);
        bCSHttpRequest.addHeader("x-bs-copy-source", "bs://" + copyObjectRequest.getSource().getBucket() + copyObjectRequest.getSource().getObject());
        if (null != copyObjectRequest.getSourceEtag()) {
            bCSHttpRequest.addHeader("x-bs-copy-source-tag", copyObjectRequest.getSourceEtag());
        }
        if (null != copyObjectRequest.getSourceDirective()) {
            bCSHttpRequest.addHeader("x-bs-copy-source-directive", copyObjectRequest.getSourceDirective());
        }
        this.populateRequestMetadata(bCSHttpRequest, copyObjectRequest.getDestMetadata());
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> copyObject(Resource resource, Resource resource2) throws BCSClientException, BCSServiceException {
        return this.copyObject(new CopyObjectRequest(resource, resource2));
    }

    public BaiduBCSResponse<Empty> copyObject(Resource resource, Resource resource2, ObjectMetadata objectMetadata) throws BCSClientException, BCSServiceException {
        return this.copyObject(new CopyObjectRequest(resource, resource2, objectMetadata));
    }

    public BaiduBCSResponse<Empty> createBucket(CreateBucketRequest createBucketRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(createBucketRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)createBucketRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(createBucketRequest.getBucket(), "The bucket parameter must be specified when creating a bucket");
        log.debug((Object)("create bucket, bucket_name [" + createBucketRequest.getBucket() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(createBucketRequest);
        if (null != createBucketRequest.getAcl()) {
            bCSHttpRequest.addHeader("x-bs-acl", createBucketRequest.getAcl().toString());
        }
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> createBucket(String string) throws BCSClientException, BCSServiceException {
        return this.createBucket(new CreateBucketRequest(string));
    }

    public BaiduBCSResponse<Empty> deleteBucket(DeleteBucketRequest deleteBucketRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(deleteBucketRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)deleteBucketRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(deleteBucketRequest.getBucket(), "The bucket parameter must be specified when deleting a bucket.");
        log.debug((Object)("delete bucket begin, bucket[" + deleteBucketRequest.getBucket() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(deleteBucketRequest);
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> deleteBucket(String string) throws BCSClientException, BCSServiceException {
        return this.deleteBucket(new DeleteBucketRequest(string));
    }

    public BaiduBCSResponse<Empty> deleteObject(DeleteObjectRequest deleteObjectRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(deleteObjectRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)deleteObjectRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(deleteObjectRequest.getBucket(), "The bucket parameter must be specified when deleting an object.");
        this.assertParameterNotNull(deleteObjectRequest.getObject(), "The object parameter must be specified when deleting an object.");
        log.debug((Object)("delete object, bucket[" + deleteObjectRequest.getBucket() + "], object[" + deleteObjectRequest.getObject() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(deleteObjectRequest);
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> deleteObject(String string, String string2) throws BCSClientException, BCSServiceException {
        return this.deleteObject(new DeleteObjectRequest(string, string2));
    }

    public BaiduBCSResponse<Policy> getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(getBucketPolicyRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)getBucketPolicyRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(getBucketPolicyRequest.getBucket(), "The bucket parameter must be specified when get policy of bucket.");
        log.debug((Object)("get bucket policy begin, bucket[" + getBucketPolicyRequest.getBucket() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(getBucketPolicyRequest);
        bCSHttpRequest.addParameter("acl", String.valueOf(1));
        return this.bcsHttpClient.execute(bCSHttpRequest, new PolicyResponseHandler());
    }

    public BaiduBCSResponse<Policy> getBucketPolicy(String string) throws BCSClientException, BCSServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(string));
    }

    public BaiduBCSResponse<DownloadObject> getObject(GetObjectRequest getObjectRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(getObjectRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)getObjectRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(getObjectRequest.getBucket(), "The bucket parameter must be specified when getting an object.");
        this.assertParameterNotNull(getObjectRequest.getObject(), "The object parameter must be specified when getting an object.");
        log.debug((Object)("get object begin, bucket[" + getObjectRequest.getBucket() + "], object[" + getObjectRequest.getObject() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(getObjectRequest);
        if (null != getObjectRequest.getRange()) {
            Pair<Long> pair = getObjectRequest.getRange();
            this.assertParameterNotNull(pair.getFirst(), "The range first parameter must be specified when getting an object by range.");
            this.assertParameterNotNull(pair.getSecond(), "The range second parameter must be specified when getting an object by range.");
            bCSHttpRequest.addHeader("Range", "bytes=" + Long.toString(pair.getFirst()) + "-" + Long.toString(pair.getSecond()));
        }
        return this.bcsHttpClient.execute(bCSHttpRequest, new ObjectResponseHandler());
    }

    public BaiduBCSResponse<DownloadObject> getObject(GetObjectRequest getObjectRequest, File file) throws BCSClientException, BCSServiceException {
        Object object;
        this.assertParameterNotNull(file, "The destination file parameter must be specified when downloading an object directly to a file.");
        BaiduBCSResponse<DownloadObject> baiduBCSResponse = this.getObject(getObjectRequest);
        DownloadObject downloadObject = baiduBCSResponse.getResult();
        if (null == downloadObject) {
            throw new BCSClientException("Get object response is empty.");
        }
        OutputStream outputStream = null;
        try {
            int n;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            object = new byte[10240];
            while ((n = downloadObject.getContent().read((byte[])object)) > -1) {
                outputStream.write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new BCSClientException("Unable to store object contents to disk: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                downloadObject.getContent().close();
            }
            catch (Exception exception) {}
        }
        if (downloadObject.getObjectMetadata().getContentLength() != file.length()) {
            object = new BCSServiceException("Maybe download incompletely. http Content-Length=" + downloadObject.getObjectMetadata().getContentLength() + " ,download size=" + file.length());
            ((BCSServiceException)object).setBcsErrorCode(0);
            ((BCSServiceException)object).setBcsErrorMessage("");
            ((BCSServiceException)object).setHttpErrorCode(200);
            ((BCSServiceException)object).setRequestId(baiduBCSResponse.getRequestId());
            throw object;
        }
        return baiduBCSResponse;
    }

    public BaiduBCSResponse<DownloadObject> getObject(String string, String string2) throws BCSClientException, BCSServiceException {
        return this.getObject(new GetObjectRequest(string, string2));
    }

    public BaiduBCSResponse<ObjectMetadata> getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws BCSClientException, BCSServiceException {
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(getObjectMetadataRequest);
        return this.bcsHttpClient.execute(bCSHttpRequest, new ObjectMetadataResponseHandler());
    }

    public BaiduBCSResponse<ObjectMetadata> getObjectMetadata(String string, String string2) throws BCSClientException, BCSServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(string, string2));
    }

    public boolean doesObjectExist(String string, String string2) throws BCSClientException, BCSServiceException {
        try {
            this.getObjectMetadata(string, string2);
        }
        catch (BCSServiceException bCSServiceException) {
            if (404 == bCSServiceException.getHttpErrorCode()) {
                return false;
            }
            throw bCSServiceException;
        }
        catch (BCSClientException bCSClientException) {
            throw bCSClientException;
        }
        return true;
    }

    public BaiduBCSResponse<Policy> getObjectPolicy(GetObjectPolicyRequest getObjectPolicyRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(getObjectPolicyRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)getObjectPolicyRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(getObjectPolicyRequest.getBucket(), "The bucket parameter must be specified when getting policy of an object.");
        this.assertParameterNotNull(getObjectPolicyRequest.getObject(), "The object parameter must be specified when getting policy of an object.");
        log.debug((Object)("get object policy, bucket[" + getObjectPolicyRequest.getBucket() + "]" + ", object[" + getObjectPolicyRequest.getObject() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(getObjectPolicyRequest);
        bCSHttpRequest.addParameter("acl", String.valueOf(1));
        return this.bcsHttpClient.execute(bCSHttpRequest, new PolicyResponseHandler());
    }

    public BaiduBCSResponse<Policy> getObjectPolicy(String string, String string2) throws BCSClientException, BCSServiceException {
        return this.getObjectPolicy(new GetObjectPolicyRequest(string, string2));
    }

    public BaiduBCSResponse<List<BucketSummary>> listBucket(ListBucketRequest listBucketRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(listBucketRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)listBucketRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(listBucketRequest);
        return this.bcsHttpClient.execute(bCSHttpRequest, new BucketListResponseHandler());
    }

    public BaiduBCSResponse<ObjectListing> listObject(ListObjectRequest listObjectRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(listObjectRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)listObjectRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(listObjectRequest.getBucket(), "The bucket parameter must be specified when listing an bucket.");
        log.debug((Object)("list object begin, bucket[" + listObjectRequest.getBucket() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(listObjectRequest);
        if (null != listObjectRequest.getPrefix() && 0 != listObjectRequest.getPrefix().length()) {
            bCSHttpRequest.addParameter("prefix", listObjectRequest.getPrefix());
        }
        if (listObjectRequest.getStart() >= 0) {
            bCSHttpRequest.addParameter("start", String.valueOf(listObjectRequest.getStart()));
        }
        if (listObjectRequest.getLimit() >= 0) {
            bCSHttpRequest.addParameter("limit", String.valueOf(listObjectRequest.getLimit()));
        }
        if (listObjectRequest.getListModel() != 0) {
            bCSHttpRequest.addParameter("dir", String.valueOf(listObjectRequest.getListModel()));
        }
        return this.bcsHttpClient.execute(bCSHttpRequest, new ObjectListResponseHandler());
    }

    public BaiduBCSResponse<Empty> putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(putBucketPolicyRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)putBucketPolicyRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(putBucketPolicyRequest.getBucket(), "The bucket parameter must be specified when setting policy or acl to a bucket.");
        log.debug((Object)("put bucket policy begin, bucket[" + putBucketPolicyRequest.getBucket() + "]"));
        if (null != putBucketPolicyRequest.getPolicy() && null != putBucketPolicyRequest.getAcl()) {
            throw new BCSClientException("Can set policy or acl to bucket at the same time.");
        }
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(putBucketPolicyRequest);
        bCSHttpRequest.addParameter("acl", String.valueOf(1));
        if (null != putBucketPolicyRequest.getPolicy()) {
            String string = putBucketPolicyRequest.getPolicy().toJson();
            byte[] byArray = ServiceUtils.toByteArray(string);
            bCSHttpRequest.setContent(new ByteArrayInputStream(byArray));
            bCSHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        } else if (null != putBucketPolicyRequest.getAcl()) {
            bCSHttpRequest.addHeader("x-bs-acl", putBucketPolicyRequest.getAcl().toString());
        }
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> putBucketPolicy(String string, Policy policy) throws BCSClientException, BCSServiceException {
        return this.putBucketPolicy(new PutBucketPolicyRequest(string, policy));
    }

    public BaiduBCSResponse<Empty> putBucketPolicy(String string, X_BS_ACL x_BS_ACL) throws BCSClientException, BCSServiceException {
        return this.putBucketPolicy(new PutBucketPolicyRequest(string, x_BS_ACL));
    }

    public BaiduBCSResponse<ObjectMetadata> putObject(PutObjectRequest putObjectRequest) throws BCSClientException, BCSServiceException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.assertParameterNotNull(putObjectRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)putObjectRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(putObjectRequest.getBucket(), "The bucket parameter must be specified when uploading an object.");
        this.assertParameterNotNull(putObjectRequest.getObject(), "The object parameter must be specified when uploading an object.");
        log.debug((Object)("put object begin,bucket[" + putObjectRequest.getBucket() + "], object[" + putObjectRequest.getObject() + "]"));
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(putObjectRequest);
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
            objectMetadata = putObjectRequest.getMetadata();
        }
        if (putObjectRequest.getFile() != null) {
            object4 = putObjectRequest.getFile();
            objectMetadata.setContentLength(((File)object4).length());
            if (objectMetadata.getContentType() == null) {
                objectMetadata.setContentType(Mimetypes.getInstance().getMimetype((File)object4));
            }
            object3 = null;
            try {
                object3 = new FileInputStream((File)object4);
                object2 = ServiceUtils.computeMD5Hash((InputStream)object3);
                objectMetadata.setContentMD5(ServiceUtils.toHex(object2));
            }
            catch (Exception exception) {
                throw new BCSClientException("Unable to calculate MD5 hash: " + exception.getMessage(), exception);
            }
            finally {
                try {
                    ((FileInputStream)object3).close();
                }
                catch (Exception exception) {}
            }
            try {
                object = new RepeatableFileInputStream((File)object4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BCSClientException("Unable to find file to upload", fileNotFoundException);
            }
        }
        object = putObjectRequest.getObjectContent();
        if (null == objectMetadata) {
            throw new BCSClientException("Put object by Inputstream. Must have Content-Length in objectMetadata.");
        }
        if (objectMetadata.getContentLength() < 0L) {
            throw new BCSClientException("Content-Length could not be empty.");
        }
        object4 = null;
        if (objectMetadata.getContentMD5() == null) {
            try {
                object = object4 = new MD5DigestCalculatingInputStream((InputStream)object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)noSuchAlgorithmException);
            }
        }
        bCSHttpRequest.setContent((InputStream)object);
        if (null != putObjectRequest.getAcl()) {
            bCSHttpRequest.addHeader("x-bs-acl", putObjectRequest.getAcl().toString());
        }
        if (objectMetadata.getContentType() == null) {
            objectMetadata.setContentType("application/octet-stream");
        }
        this.populateRequestMetadata(bCSHttpRequest, objectMetadata);
        object3 = this.bcsHttpClient.execute(bCSHttpRequest, new ObjectMetadataResponseHandler());
        try {
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to cleanly close input stream: " + exception.getMessage()), (Throwable)exception);
        }
        object2 = objectMetadata.getContentMD5();
        if (null != object4) {
            object2 = ServiceUtils.toHex(((MD5DigestCalculatingInputStream)object4).getMd5Digest());
        }
        if (!object2.equalsIgnoreCase(((ObjectMetadata)((BaiduBCSResponse)object3).getResult()).getContentMD5())) {
            throw new BCSClientException("Client calculated content md5 didn't match md5 calculated by Baidu BCS. ");
        }
        return object3;
    }

    public BaiduBCSResponse<ObjectMetadata> putObject(String string, String string2, File file) throws BCSClientException, BCSServiceException {
        return this.putObject(new PutObjectRequest(string, string2, file));
    }

    public BaiduBCSResponse<ObjectMetadata> putObject(String string, String string2, InputStream inputStream, ObjectMetadata objectMetadata) throws BCSClientException, BCSServiceException {
        return this.putObject(new PutObjectRequest(string, string2, inputStream, objectMetadata));
    }

    public BaiduBCSResponse<Empty> putObjectPolicy(PutObjectPolicyRequest putObjectPolicyRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(putObjectPolicyRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)putObjectPolicyRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(putObjectPolicyRequest.getBucket(), "The bucket parameter must be specified when setting policy or acl to an object.");
        this.assertParameterNotNull(putObjectPolicyRequest.getObject(), "The object parameter must be specified when setting policy or acl to an object.");
        log.debug((Object)("put object policy begin, bucket[" + putObjectPolicyRequest.getBucket() + "]"));
        if (null != putObjectPolicyRequest.getPolicy() && null != putObjectPolicyRequest.getAcl()) {
            throw new BCSClientException("Can set policy or acl to object at the same time.");
        }
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(putObjectPolicyRequest);
        bCSHttpRequest.addParameter("acl", String.valueOf(1));
        if (null != putObjectPolicyRequest.getPolicy()) {
            String string = putObjectPolicyRequest.getPolicy().toJson();
            byte[] byArray = ServiceUtils.toByteArray(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            bCSHttpRequest.setContent(byteArrayInputStream);
            bCSHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        } else if (null != putObjectPolicyRequest.getAcl()) {
            bCSHttpRequest.addHeader("x-bs-acl", putObjectPolicyRequest.getAcl().toString());
        }
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> putObjectPolicy(String string, String string2, Policy policy) throws BCSClientException, BCSServiceException {
        return this.putObjectPolicy(new PutObjectPolicyRequest(string, string2, policy));
    }

    public BaiduBCSResponse<Empty> putObjectPolicy(String string, String string2, X_BS_ACL x_BS_ACL) throws BCSClientException, BCSServiceException {
        return this.putObjectPolicy(new PutObjectPolicyRequest(string, string2, x_BS_ACL));
    }

    public BaiduBCSResponse<ObjectMetadata> putSuperfile(PutSuperfileRequest putSuperfileRequest) throws BCSClientException, BCSServiceException {
        Object object;
        this.assertParameterNotNull(putSuperfileRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)putSuperfileRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(putSuperfileRequest.getSubObjectList(), "The sub-object list parameter in Request must be specified.");
        this.assertParameterNotNull(putSuperfileRequest.getBucket(), "The bucket parameter must be specified when creating a superfile.");
        this.assertParameterNotNull(putSuperfileRequest.getObject(), "The object parameter must be specified when creating a superfile.");
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(putSuperfileRequest);
        HashMap hashMap = new HashMap();
        hashMap.put("object_list", new LinkedHashMap());
        for (int i = 0; i < putSuperfileRequest.getSubObjectList().size(); ++i) {
            object = putSuperfileRequest.getSubObjectList().get(i);
            ((Map)hashMap.get("object_list")).put("part_" + i, new HashMap());
            ((Map)((Map)hashMap.get("object_list")).get("part_" + i)).put("url", "bs://" + ((SuperfileSubObject)object).getBucket() + ((SuperfileSubObject)object).getObject());
            ((Map)((Map)hashMap.get("object_list")).get("part_" + i)).put("etag", ((SuperfileSubObject)object).getEtag());
        }
        JSONSerializer jSONSerializer = new JSONSerializer();
        object = jSONSerializer.deepSerialize(hashMap);
        byte[] byArray = ServiceUtils.toByteArray((String)object);
        bCSHttpRequest.setContent(new ByteArrayInputStream(byArray));
        bCSHttpRequest.addHeader("Content-Length", String.valueOf(byArray.length));
        bCSHttpRequest.addParameter("superfile", String.valueOf(1));
        if (null != putSuperfileRequest.getObjectMetadata()) {
            this.populateRequestMetadata(bCSHttpRequest, putSuperfileRequest.getObjectMetadata());
        }
        return this.bcsHttpClient.execute(bCSHttpRequest, new ObjectMetadataResponseHandler());
    }

    public BaiduBCSResponse<ObjectMetadata> putSuperfile(String string, String string2, List<SuperfileSubObject> list) throws BCSClientException, BCSServiceException {
        return this.putSuperfile(new PutSuperfileRequest(string, string2, list));
    }

    public BaiduBCSResponse<ObjectMetadata> putSuperfile(String string, String string2, ObjectMetadata objectMetadata, List<SuperfileSubObject> list) throws BCSClientException, BCSServiceException {
        return this.putSuperfile(new PutSuperfileRequest(string, string2, objectMetadata, list));
    }

    public BaiduBCSResponse<Empty> setObjectMetadata(SetObjectMetadataRequest setObjectMetadataRequest) throws BCSClientException, BCSServiceException {
        this.assertParameterNotNull(setObjectMetadataRequest, "The request parameter can be null.");
        this.assertParameterNotNull((Object)setObjectMetadataRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(setObjectMetadataRequest.getBucket(), "The bucket parameter must be specified when setting object meta.");
        this.assertParameterNotNull(setObjectMetadataRequest.getObject(), "The object parameter must be specified when setting object meta.");
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(setObjectMetadataRequest);
        if (null != setObjectMetadataRequest.getMetadata()) {
            setObjectMetadataRequest.getMetadata().setContentMD5("");
            setObjectMetadataRequest.getMetadata().setContentLength(0L);
        }
        this.populateRequestMetadata(bCSHttpRequest, setObjectMetadataRequest.getMetadata());
        bCSHttpRequest.addHeader("x-bs-copy-source", "bs://" + setObjectMetadataRequest.getBucket() + setObjectMetadataRequest.getObject());
        return this.bcsHttpClient.execute(bCSHttpRequest, new VoidResponseHandler());
    }

    public BaiduBCSResponse<Empty> setObjectMetadata(String string, String string2, ObjectMetadata objectMetadata) throws BCSClientException, BCSServiceException {
        return this.setObjectMetadata(new SetObjectMetadataRequest(string, string2, objectMetadata));
    }

    public String generateUrl(GenerateUrlRequest generateUrlRequest) {
        this.assertParameterNotNull((Object)generateUrlRequest.getHttpMethod(), "The http method parameter in Request must be specified.");
        this.assertParameterNotNull(generateUrlRequest.getBucket(), "The bucket parameter must be specified.");
        this.assertParameterNotNull(generateUrlRequest.getObject(), "The object parameter must be specified.");
        BCSHttpRequest bCSHttpRequest = this.createHttpRequest(generateUrlRequest);
        BCSSigner.sign(generateUrlRequest, bCSHttpRequest, this.credentials, generateUrlRequest.getBcsSignCondition());
        return this.bcsHttpClient.getHttpRequestFactory().buildUri(this.bcsHttpClient.getConfig(), bCSHttpRequest);
    }

    private BCSHttpRequest createHttpRequest(BaiduBCSRequest baiduBCSRequest) {
        DefaultBCSHttpRequest defaultBCSHttpRequest = new DefaultBCSHttpRequest(baiduBCSRequest);
        defaultBCSHttpRequest.setEndpoint(this.endpoint);
        defaultBCSHttpRequest.setResourcePath(this.buildResourcePath(baiduBCSRequest.getBucket(), baiduBCSRequest.getObject()));
        defaultBCSHttpRequest.setHttpMethod(baiduBCSRequest.getHttpMethod());
        BCSSigner.sign(baiduBCSRequest, defaultBCSHttpRequest, this.credentials);
        return defaultBCSHttpRequest;
    }

    private void populateRequestMetadata(BCSHttpRequest bCSHttpRequest, ObjectMetadata objectMetadata) {
        Object object;
        if (null == objectMetadata) {
            log.debug((Object)"populateRequestMetadata, metadata is null");
            return;
        }
        Map<String, Object> map = objectMetadata.getRawMetadata();
        if (map != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                bCSHttpRequest.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        if ((object = objectMetadata.getUserMetadata()) != null) {
            for (Map.Entry entry : object.entrySet()) {
                bCSHttpRequest.addHeader("x-bs-meta-" + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void assertParameterNotNull(Object object, String string) {
        if (null == object) {
            throw new IllegalArgumentException(string);
        }
    }

    private String buildResourcePath(String string, String string2) {
        if (!string2.startsWith("/")) {
            throw new BCSClientException("BCS object must start with a slash.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (!string2.equals("/")) {
            stringBuilder.append(ServiceUtils.urlEncode(string2));
        }
        return stringBuilder.toString();
    }
}

