/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.auth;

import com.baidu.inf.iis.bcs.auth.BCSCredentials;
import com.baidu.inf.iis.bcs.auth.BCSSignCondition;
import com.baidu.inf.iis.bcs.auth.SigningAlgorithm;
import com.baidu.inf.iis.bcs.http.BCSHttpRequest;
import com.baidu.inf.iis.bcs.http.DefaultBCSHttpRequest;
import com.baidu.inf.iis.bcs.http.HttpMethodName;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.request.BaiduBCSRequest;
import com.baidu.inf.iis.bcs.utils.ServiceUtils;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BCSSigner {
    public static void main(String[] stringArray) throws URISyntaxException {
        BaiduBCSRequest baiduBCSRequest = new BaiduBCSRequest("bucket", "object", HttpMethodName.GET){};
        BCSSignCondition bCSSignCondition = new BCSSignCondition();
        bCSSignCondition.setIp("192.168.1.1");
        bCSSignCondition.setSize(1234L);
        bCSSignCondition.setTime(4321L);
        BCSCredentials bCSCredentials = new BCSCredentials("akakak", "sksksk");
        DefaultBCSHttpRequest defaultBCSHttpRequest = new DefaultBCSHttpRequest();
        defaultBCSHttpRequest.setHttpMethod(baiduBCSRequest.getHttpMethod());
        defaultBCSHttpRequest.setEndpoint("10.81.2.114:8685");
        BCSSigner.sign(baiduBCSRequest, defaultBCSHttpRequest, bCSCredentials, bCSSignCondition);
        System.out.println(((Object)defaultBCSHttpRequest).toString());
    }

    public static void sign(BaiduBCSRequest baiduBCSRequest, BCSHttpRequest bCSHttpRequest, BCSCredentials bCSCredentials) {
        BCSSigner.sign(baiduBCSRequest, bCSHttpRequest, bCSCredentials, null);
    }

    public static void sign(BaiduBCSRequest baiduBCSRequest, BCSHttpRequest bCSHttpRequest, BCSCredentials bCSCredentials, BCSSignCondition bCSSignCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (null == baiduBCSRequest.getHttpMethod()) {
            throw new BCSClientException("Sign failed! Param: httpMethod, bucket, object can not be empty!");
        }
        if (null == baiduBCSRequest.getBucket()) {
            throw new BCSClientException("Sign failed! Param: httpMethod, bucket, object can not be empty!");
        }
        if (null == baiduBCSRequest.getObject() || 0 == baiduBCSRequest.getObject().length()) {
            throw new BCSClientException("Sign failed! Param: httpMethod, bucket, object can not be empty!");
        }
        stringBuilder.append("MBO");
        stringBuilder2.append("Method=").append(baiduBCSRequest.getHttpMethod().toString()).append("\n");
        stringBuilder2.append("Bucket=").append(baiduBCSRequest.getBucket()).append("\n");
        stringBuilder2.append("Object=").append(baiduBCSRequest.getObject()).append("\n");
        if (bCSSignCondition != null) {
            if (0 != bCSSignCondition.getIp().length()) {
                stringBuilder.append("I");
                stringBuilder2.append("Ip=").append(bCSSignCondition.getIp()).append("\n");
            }
            if (bCSSignCondition.getTime() > 0L) {
                stringBuilder.append("T");
                stringBuilder2.append("Time=").append(bCSSignCondition.getTime()).append("\n");
                bCSHttpRequest.addParameter("time", String.valueOf(bCSSignCondition.getTime()));
            }
            if (bCSSignCondition.getSize() > 0L) {
                stringBuilder.append("S");
                stringBuilder2.append("Size=").append(bCSSignCondition.getSize()).append("\n");
                bCSHttpRequest.addParameter("size", String.valueOf(bCSSignCondition.getSize()));
            }
        }
        stringBuilder2.insert(0, "\n");
        stringBuilder2.insert(0, stringBuilder.toString());
        byte[] byArray = new byte[]{};
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(bCSCredentials.getSecretKey().getBytes(), SigningAlgorithm.HmacSHA1.toString());
            Mac mac = Mac.getInstance(secretKeySpec.getAlgorithm());
            mac.init(secretKeySpec);
            byArray = mac.doFinal(ServiceUtils.toByteArray(stringBuilder2.toString()));
            bCSHttpRequest.addParameter("sign", stringBuilder.append(":").append(bCSCredentials.getAccessKey()).append(":").append(ServiceUtils.toBase64(byArray)).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new BCSClientException("NoSuchAlgorithmException. Sign bcs failed!", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new BCSClientException("InvalidKeyException. Sign bcs failed!", invalidKeyException);
        }
        catch (RuntimeException runtimeException) {
            throw new BCSClientException("Sign bcs failed!", runtimeException);
        }
    }
}

