/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.handler;

import com.baidu.inf.iis.bcs.http.BCSHttpResponse;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.model.ObjectMetadata;
import com.baidu.inf.iis.bcs.response.BaiduBCSResponse;
import com.baidu.inf.iis.bcs.utils.ServiceUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpResponseHandler<T> {
    private static final Log log = LogFactory.getLog(HttpResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    protected String getResponseContentByStr(BCSHttpResponse bCSHttpResponse) {
        if (null != bCSHttpResponse.getContent()) {
            byte[] byArray = new byte[1024];
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n;
                while ((n = bCSHttpResponse.getContent().read(byArray)) > 0) {
                    stringBuilder.append(new String(byArray, 0, n));
                }
            }
            catch (IOException iOException) {
                throw new BCSClientException("Read http response body error.", iOException);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public abstract BaiduBCSResponse<T> handle(BCSHttpResponse var1);

    protected BaiduBCSResponse<T> parseResponseMetadata(BCSHttpResponse bCSHttpResponse) {
        BaiduBCSResponse baiduBCSResponse = new BaiduBCSResponse();
        String string = bCSHttpResponse.getHeaders().get("x-bs-request-id");
        baiduBCSResponse.setRequestId(string);
        log.info((Object)("Bcs requestId:" + string));
        return baiduBCSResponse;
    }

    protected void populateObjectMetadata(BCSHttpResponse bCSHttpResponse, ObjectMetadata objectMetadata) {
        for (Map.Entry<String, String> entry : bCSHttpResponse.getHeaders().entrySet()) {
            String string = entry.getKey();
            if (string.startsWith("x-bs-meta-")) {
                string = string.substring("x-bs-meta-".length());
                objectMetadata.addUserMetadata(string, entry.getValue());
                continue;
            }
            if (string.equals("Last-Modified")) {
                try {
                    objectMetadata.setHeader(string, ServiceUtils.parseRfc822Date(entry.getValue()));
                }
                catch (ParseException parseException) {
                    log.warn((Object)("Unable to parse last modified date: " + entry.getValue()), (Throwable)parseException);
                }
                continue;
            }
            if (ignoredHeaders.contains(string)) continue;
            objectMetadata.setHeader(string, entry.getValue());
        }
    }

    public boolean isNeedsConnectionLeftOpen() {
        return false;
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-bs-request-id");
    }
}

