/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.http;

import com.baidu.inf.iis.bcs.handler.ErrorResponseHandler;
import com.baidu.inf.iis.bcs.handler.HttpResponseHandler;
import com.baidu.inf.iis.bcs.http.BCSHttpRequest;
import com.baidu.inf.iis.bcs.http.BCSHttpResponse;
import com.baidu.inf.iis.bcs.http.ClientConfiguration;
import com.baidu.inf.iis.bcs.http.HttpClientFactory;
import com.baidu.inf.iis.bcs.http.HttpRequestFactory;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.model.BCSServiceException;
import com.baidu.inf.iis.bcs.response.BaiduBCSResponse;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BCSHttpClient {
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final Log log = LogFactory.getLog(BCSHttpClient.class);
    private HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    private HttpClientFactory httpClientFactory = new HttpClientFactory();
    private final ClientConfiguration config;
    private HttpClient httpClient;
    private ErrorResponseHandler errorResponseHandler = new ErrorResponseHandler();

    public BCSHttpClient(ClientConfiguration clientConfiguration) {
        this.config = clientConfiguration;
        this.httpClient = this.httpClientFactory.createHttpClient(this.config);
    }

    private BCSHttpResponse createBCSHttpResponse(HttpResponse httpResponse) throws IllegalStateException, IOException {
        BCSHttpResponse bCSHttpResponse = new BCSHttpResponse();
        if (null != httpResponse.getEntity()) {
            bCSHttpResponse.setContent(httpResponse.getEntity().getContent());
        }
        bCSHttpResponse.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        bCSHttpResponse.setStatusText(httpResponse.getStatusLine().getReasonPhrase());
        for (Header header : httpResponse.getAllHeaders()) {
            bCSHttpResponse.addHeader(header.getName(), header.getValue());
        }
        return bCSHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BaiduBCSResponse<T> execute(BCSHttpRequest bCSHttpRequest, HttpResponseHandler<T> httpResponseHandler) {
        HttpRequestBase httpRequestBase = this.httpRequestFactory.createHttpRequestBase(this.config, bCSHttpRequest);
        boolean bl = false;
        this.httpClient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        int n = 0;
        while (true) {
            HttpResponse httpResponse = null;
            try {
                Object object;
                this.pauseExponentially(n);
                ++n;
                httpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase);
                log.info((Object)("Send Request Finish: " + httpResponse.getStatusLine() + ", " + httpRequestBase.getURI()));
                if (this.isRequestSuccessful(httpResponse)) {
                    bl = httpResponseHandler.isNeedsConnectionLeftOpen();
                    object = this.handleHttpResponse(bCSHttpRequest, httpResponse, httpResponseHandler);
                    return object;
                }
                object = this.handleErrorHttpResponse(bCSHttpRequest, httpResponse, this.errorResponseHandler).getResult();
                if (this.shouldRetry((Exception)object, n)) continue;
                throw object;
            }
            catch (ClientProtocolException clientProtocolException) {
                log.warn((Object)("Unable to execute HTTP request: " + clientProtocolException.getMessage()));
                if (this.shouldRetry((Exception)((Object)clientProtocolException), n)) continue;
                throw new BCSClientException("Send to server failed: " + clientProtocolException.getMessage(), clientProtocolException);
            }
            catch (IOException iOException) {
                log.warn((Object)("Unable to execute HTTP request: " + iOException.getMessage()));
                if (this.shouldRetry(iOException, n)) continue;
                throw new BCSClientException("Send to server failed: " + iOException.getMessage(), iOException);
            }
            finally {
                if (bl) continue;
                try {
                    httpResponse.getEntity().getContent().close();
                }
                catch (Throwable throwable) {}
                continue;
            }
            break;
        }
    }

    private BaiduBCSResponse<BCSServiceException> handleErrorHttpResponse(BCSHttpRequest bCSHttpRequest, HttpResponse httpResponse, HttpResponseHandler<BCSServiceException> httpResponseHandler) throws IllegalStateException, IOException {
        BCSHttpResponse bCSHttpResponse = this.createBCSHttpResponse(httpResponse);
        bCSHttpResponse.setRequest(bCSHttpRequest);
        return httpResponseHandler.handle(bCSHttpResponse);
    }

    private <T> BaiduBCSResponse<T> handleHttpResponse(BCSHttpRequest bCSHttpRequest, HttpResponse httpResponse, HttpResponseHandler<T> httpResponseHandler) throws IllegalStateException, IOException {
        BCSHttpResponse bCSHttpResponse = this.createBCSHttpResponse(httpResponse);
        bCSHttpResponse.setRequest(bCSHttpRequest);
        return httpResponseHandler.handle(bCSHttpResponse);
    }

    private boolean isRequestSuccessful(HttpResponse httpResponse) {
        int n = httpResponse.getStatusLine().getStatusCode();
        return n / 100 == 2;
    }

    public HttpRequestFactory getHttpRequestFactory() {
        return this.httpRequestFactory;
    }

    public void setHttpRequestFactory(HttpRequestFactory httpRequestFactory) {
        this.httpRequestFactory = httpRequestFactory;
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    public boolean shouldRetry(Exception exception, int n) {
        BCSServiceException bCSServiceException;
        if (n > this.config.getMaxErrorRetry()) {
            log.warn((Object)("Max error retry is[" + this.config.getMaxErrorRetry() + "]. Stop retry."));
            return false;
        }
        if (exception instanceof NoHttpResponseException || exception instanceof SocketException || exception instanceof SocketTimeoutException) {
            log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            return true;
        }
        if (exception instanceof BCSServiceException && ((bCSServiceException = (BCSServiceException)exception).getBcsErrorCode() == 500 || bCSServiceException.getBcsErrorCode() == 503)) {
            log.debug((Object)("Retrying on server response[" + bCSServiceException.getBcsErrorCode() + "]"));
            return true;
        }
        log.warn((Object)"Should not retry.");
        return false;
    }

    private void pauseExponentially(int n) {
        if (0 == n) {
            return;
        }
        long l = 300L;
        long l2 = (long)(Math.pow(2.0, n) * (double)l);
        l2 = Math.min(l2, 20000L);
        log.debug((Object)("Retriable error detected, will retry in " + l2 + "ms, attempt number: " + n));
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new BCSClientException(interruptedException.getMessage(), interruptedException);
        }
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

