/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepeatableInputStream
extends InputStream {
    private static final Log log = LogFactory.getLog(RepeatableInputStream.class);
    private InputStream is = null;
    private int bufferSize = 0;
    private int bufferOffset = 0;
    private long bytesReadPastMark = 0L;
    private byte[] buffer = null;

    public RepeatableInputStream(InputStream inputStream, int n) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = inputStream;
        this.bufferSize = n;
        this.buffer = new byte[this.bufferSize];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Underlying input stream will be repeatable up to " + this.buffer.length + " bytes"));
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public InputStream getWrappedInputStream() {
        return this.is;
    }

    public synchronized void mark(int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input stream marked at " + this.bytesReadPastMark + " bytes"));
        }
        if (this.bytesReadPastMark <= (long)this.bufferSize && this.buffer != null) {
            byte[] byArray = new byte[this.bufferSize];
            System.arraycopy(this.buffer, this.bufferOffset, byArray, 0, (int)(this.bytesReadPastMark - (long)this.bufferOffset));
            this.buffer = byArray;
            this.bytesReadPastMark -= (long)this.bufferOffset;
            this.bufferOffset = 0;
        } else {
            this.bufferOffset = 0;
            this.bytesReadPastMark = 0L;
            this.buffer = new byte[this.bufferSize];
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != -1) {
            return byArray[0];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        if ((long)this.bufferOffset < this.bytesReadPastMark && this.buffer != null) {
            int n3 = byArray2.length;
            if ((long)(this.bufferOffset + n3) > this.bytesReadPastMark) {
                n3 = (int)this.bytesReadPastMark - this.bufferOffset;
            }
            System.arraycopy(this.buffer, this.bufferOffset, byArray, n, n3);
            this.bufferOffset += n3;
            return n3;
        }
        int n4 = this.is.read(byArray2);
        if (n4 <= 0) {
            return n4;
        }
        if (this.bytesReadPastMark + (long)n4 <= (long)this.bufferSize) {
            System.arraycopy(byArray2, 0, this.buffer, (int)this.bytesReadPastMark, n4);
            this.bufferOffset += n4;
        } else if (this.buffer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Buffer size " + this.bufferSize + " has been exceeded and the input stream " + "will not be repeatable until the next mark. Freeing buffer memory"));
            }
            this.buffer = null;
        }
        System.arraycopy(byArray2, 0, byArray, n, n4);
        this.bytesReadPastMark += (long)n4;
        return n4;
    }

    public void reset() throws IOException {
        if (this.bytesReadPastMark <= (long)this.bufferSize) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reset after reading " + this.bytesReadPastMark + " bytes."));
            }
        } else {
            throw new IOException("Input stream cannot be reset as " + this.bytesReadPastMark + " bytes have been written, exceeding the available buffer size of " + this.bufferSize);
        }
        this.bufferOffset = 0;
    }
}

