/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.http;

import com.baidu.inf.iis.bcs.http.BCSHttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;

class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private static final Log log = LogFactory.getLog(RepeatableInputStreamRequestEntity.class);

    RepeatableInputStreamRequestEntity(BCSHttpRequest bCSHttpRequest) {
        String string;
        this.setChunked(false);
        long l = -1L;
        try {
            string = bCSHttpRequest.getHeaders().get("Content-Length");
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)"Unable to parse content length from request.  Buffering contents in memory.");
        }
        string = bCSHttpRequest.getHeaders().get("Content-Type");
        this.inputStreamRequestEntity = new InputStreamEntity(bCSHttpRequest.getContent(), l);
        this.inputStreamRequestEntity.setContentType(string);
        this.content = bCSHttpRequest.getContent();
        this.setContent(this.content);
        this.setContentType(string);
        this.setContentLength(l);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.inputStreamRequestEntity.writeTo(outputStream);
    }
}

