/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mimetypes {
    private static final Log log = LogFactory.getLog(Mimetypes.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    private static Mimetypes mimetypes = null;
    private HashMap<String, String> extensionToMimetypeMap = new HashMap();

    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream inputStream = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (inputStream != null) {
            if (log.isDebugEnabled()) {
                log.info((Object)"Loading mime types from file in the classpath: mime.types");
            }
            try {
                mimetypes.loadAndReplaceMimetypes(inputStream);
            }
            catch (IOException iOException) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Failed to load mime types from file in the classpath: mime.types", (Throwable)iOException);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Unable to find 'mime.types' file in classpath");
        }
        return mimetypes;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }

    public String getMimetype(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0 && n + 1 < string.length()) {
            String string2 = string.substring(n + 1);
            if (this.extensionToMimetypeMap.keySet().contains(string2)) {
                String string3 = this.extensionToMimetypeMap.get(string2);
                if (log.isDebugEnabled()) {
                    log.info((Object)("Recognised extension '" + string2 + "', mimetype is: '" + string3 + "'"));
                }
                return string3;
            }
            if (log.isDebugEnabled()) {
                log.info((Object)("Extension '" + string2 + "' is unrecognized in mime type listing" + ", using default mime type: '" + MIMETYPE_OCTET_STREAM + "'"));
            }
        } else if (log.isDebugEnabled()) {
            log.info((Object)("File name has no extension, mime type cannot be recognised for: " + string));
        }
        return MIMETYPE_OCTET_STREAM;
    }

    public void loadAndReplaceMimetypes(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            if (stringTokenizer.countTokens() > 1) {
                String string2 = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.extensionToMimetypeMap.put(string3, string2);
                    if (!log.isDebugEnabled()) continue;
                    log.info((Object)("Setting mime type for extension '" + string3 + "' to '" + string2 + "'"));
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.info((Object)("Ignoring mimetype with no associated file extensions: '" + string + "'"));
        }
    }
}

