/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.inf.iis.bcs.utils;

import com.baidu.inf.iis.bcs.http.BCSHttpRequest;
import com.baidu.inf.iis.bcs.model.BCSClientException;
import com.baidu.inf.iis.bcs.utils.Constants;
import com.baidu.inf.iis.bcs.utils.DateUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    private static final Log log = LogFactory.getLog(ServiceUtils.class);
    protected static final DateUtils dateUtils = new DateUtils();

    public static byte[] computeMD5Hash(byte[] byArray) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            byte[] byArray;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = new byte[16384];
            int n = -1;
            while ((n = bufferedInputStream.read(byArray2, 0, byArray2.length)) != -1) {
                messageDigest.update(byArray2, 0, n);
            }
            byte[] byArray3 = byArray = messageDigest.digest();
            return byArray3;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                log.warn((Object)("Unable to close input stream of hash candidate: " + exception));
            }
        }
    }

    public static URL convertRequestToUrl(BCSHttpRequest bCSHttpRequest) {
        String string = bCSHttpRequest.getEndpoint() + "/" + bCSHttpRequest.getResourcePath();
        boolean bl = true;
        for (String string2 : bCSHttpRequest.getParameters().keySet()) {
            if (bl) {
                string = string + "?";
                bl = false;
            } else {
                string = string + "&";
            }
            String string3 = bCSHttpRequest.getParameters().get(string2);
            string = string + string2 + "=" + ServiceUtils.urlEncode(string3);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BCSClientException("Unable to convert request to well formed URL: " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static String formatIso8601Date(Date date) {
        return dateUtils.formatIso8601Date(date);
    }

    public static String formatRfc822Date(Date date) {
        return dateUtils.formatRfc822Date(date);
    }

    public static byte[] fromBase64(String string) {
        byte[] byArray;
        try {
            byArray = Base64.decodeBase64((byte[])string.getBytes(Constants.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)"Tried to Base64-decode a String with the wrong encoding: ", (Throwable)unsupportedEncodingException);
            byArray = Base64.decodeBase64((byte[])string.getBytes());
        }
        return byArray;
    }

    public static byte[] fromHex(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 2];
        String string2 = null;
        int n = 0;
        for (int i = 0; i < string.length(); i += 2) {
            string2 = string.substring(i, i + 2);
            byArray[n++] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static String join(List<String> list) {
        String string = "";
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                string = string + ", ";
            }
            string = string + string2;
            bl = false;
        }
        return string;
    }

    public static Date parseIso8601Date(String string) throws ParseException {
        return dateUtils.parseIso8601Date(string);
    }

    public static Date parseRfc822Date(String string) throws ParseException {
        return dateUtils.parseRfc822Date(string);
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String toBase64(byte[] byArray) {
        byte[] byArray2 = Base64.encodeBase64((byte[])byArray);
        return new String(byArray2);
    }

    public static byte[] toByteArray(String string) {
        try {
            return string.getBytes(Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)("Encoding " + Constants.DEFAULT_ENCODING + " is not supported"), (Throwable)unsupportedEncodingException);
            return string.getBytes();
        }
    }

    public static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() == 1) {
                stringBuilder.append("0");
            } else if (string.length() == 8) {
                string = string.substring(6);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toLowerCase(Locale.getDefault());
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = URLEncoder.encode(string, Constants.DEFAULT_ENCODING);
            return string2.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BCSClientException("Unable to encode path: " + string, unsupportedEncodingException);
        }
    }
}

