package com.biz.crm.approval.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.approval.service.MdmApprovalConfigService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 审批配置主表
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Slf4j
@RestController
@RequestMapping("/mdmApprovalConfigController")
@Api(tags = "MDM-审批配置主表")
@CrmGlobalLog
public class MdmApprovalConfigController {

    @Autowired
    private MdmApprovalConfigService mdmApprovalConfigService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/findApprovalConfigPageList")
    public Result<PageResult<MdmApprovalConfigRespVo>> findApprovalConfigPageList(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        return Result.ok(mdmApprovalConfigService.findApprovalConfigPageList(mdmApprovalConfigReqVo));
    }

    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    public Result<List<MdmApprovalConfigRespVo>> list(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        return Result.ok(mdmApprovalConfigService.findApprovalConfigList(mdmApprovalConfigReqVo));
    }

    @ApiOperation(value = "通过id获取编辑详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/queryForUpdate")
    public Result<MdmApprovalConfigRespVo> queryForUpdate(@RequestParam(value = "id", required = true) String id) {
        MdmApprovalConfigRespVo respVo = mdmApprovalConfigService.queryById(id);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        mdmApprovalConfigService.save(mdmApprovalConfigReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        mdmApprovalConfigService.update(mdmApprovalConfigReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmApprovalConfigService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "开启", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/open")
    public Result open(@RequestBody List<String> ids) {
        mdmApprovalConfigService.open(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "关闭", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/close")
    public Result close(@RequestBody List<String> ids) {
        mdmApprovalConfigService.close(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "（请勿调用）查询redis待缓存数据", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "businessCode", value = "业务编码", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/queryForRedis")
    public Result<MdmApprovalConfigRedisVo> queryForRedis(@RequestParam(value = "businessCode", required = true) String businessCode) {
        return Result.ok(mdmApprovalConfigService.queryForRedis(businessCode));
    }
}
